/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.util.splitarray;

import java.util.Arrays;

public final class SplitArray24 {
    private static final int LOG_CHUNK_SIZE = 14;
    private static final int CHUNK_SIZE = 16384;
    private short[][] array1 = new short[0][];
    private byte[][] array2 = new byte[0][];
    private long size;

    public SplitArray24() {
    }

    public SplitArray24(long size) {
        this.resize(size);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int get(int index) {
        byte[] array21;
        assert ((long)index < this.size);
        int index1 = index >> 14;
        int index2 = index & 0x3FFF;
        short[] array11 = this.array1[index1];
        if (array11 == null) {
            SplitArray24 splitArray24 = this;
            synchronized (splitArray24) {
                array11 = this.array1[index1];
                assert (array11 != null);
            }
        }
        if ((array21 = this.array2[index1]) == null) {
            SplitArray24 splitArray24 = this;
            synchronized (splitArray24) {
                array21 = this.array2[index1];
                assert (array21 != null);
            }
        }
        return (array11[index2] & 0xFFFF) << 8 | array21[index2] & 0xFF;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int get(long index) {
        byte[] array21;
        assert (index < this.size);
        int index1 = (int)(index >> 14);
        int index2 = (int)(index & 0x3FFFL);
        short[] array11 = this.array1[index1];
        if (array11 == null) {
            SplitArray24 splitArray24 = this;
            synchronized (splitArray24) {
                array11 = this.array1[index1];
                assert (array11 != null);
            }
        }
        if ((array21 = this.array2[index1]) == null) {
            SplitArray24 splitArray24 = this;
            synchronized (splitArray24) {
                array21 = this.array2[index1];
                assert (array21 != null);
            }
        }
        return (array11[index2] & 0xFFFF) << 8 | array21[index2] & 0xFF;
    }

    public int get(int index, int bitOffset, int nrOfBits) {
        assert ((long)index < this.size);
        assert (nrOfBits <= 24);
        assert (nrOfBits > 0);
        assert (bitOffset + nrOfBits <= 24);
        return this.get(index) >>> bitOffset & (1 << nrOfBits) - 1;
    }

    public int get(long index, int bitOffset, int nrOfBits) {
        assert (index < this.size);
        assert (nrOfBits <= 24);
        assert (nrOfBits > 0);
        assert (bitOffset + nrOfBits <= 24);
        return this.get(index) >>> bitOffset & (1 << nrOfBits) - 1;
    }

    public void set(int index, int value) {
        assert ((long)index < this.size);
        int index1 = index >> 14;
        int index2 = index & 0x3FFF;
        this.array1[index1][index2] = (short)(value >> 8);
        this.array2[index1][index2] = (byte)(value & 0xFF);
    }

    public void set(long index, int value) {
        assert (index < this.size);
        int index1 = (int)(index >> 14);
        int index2 = (int)(index & 0x3FFFL);
        this.array1[index1][index2] = (short)(value >> 8);
        this.array2[index1][index2] = (byte)(value & 0xFF);
    }

    public void set(int index, int value, int bitOffset, int nrOfBits) {
        assert ((long)index < this.size);
        assert (nrOfBits <= 24);
        assert (nrOfBits > 0);
        assert (bitOffset + nrOfBits <= 24);
        int newVal = this.get(index);
        newVal &= ~((1 << nrOfBits) - 1 << bitOffset);
        this.set(index, newVal |= (value & (1 << nrOfBits) - 1) << bitOffset);
    }

    public void set(long index, int value, int bitOffset, int nrOfBits) {
        assert (index < this.size);
        assert (nrOfBits <= 24);
        assert (nrOfBits > 0);
        assert (bitOffset + nrOfBits <= 24);
        int newVal = this.get(index);
        newVal &= ~((1 << nrOfBits) - 1 << bitOffset);
        this.set(index, newVal |= (value & (1 << nrOfBits) - 1) << bitOffset);
    }

    public void add(int value) {
        long newSize = this.size + 1L;
        if (newSize > (long)(this.array1.length * 16384)) {
            this.resize(newSize);
        } else {
            this.size = newSize;
        }
        this.set(newSize - 1L, value);
    }

    public long size() {
        return this.size;
    }

    public int[] toArray() {
        int sz = (int)this.size;
        int[] result = new int[sz];
        for (int i = 0; i < sz; ++i) {
            result[i] = this.get(i);
        }
        return result;
    }

    public void resize(int newSize) {
        if ((long)newSize < this.size) {
            this.size = newSize;
            return;
        }
        this.resize((long)newSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resize(long newSize) {
        if (newSize < this.size) {
            this.size = newSize;
            return;
        }
        this.size = newSize;
        if (newSize <= (long)(this.array1.length * 16384)) {
            return;
        }
        short[][] newArray1 = new short[(int)(newSize + 16384L - 1L) >> 14][];
        System.arraycopy(this.array1, 0, newArray1, 0, this.array1.length);
        byte[][] newArray2 = new byte[(int)(newSize + 16384L - 1L) >> 14][];
        System.arraycopy(this.array2, 0, newArray2, 0, this.array2.length);
        for (int i = this.array1.length; i < newArray1.length; ++i) {
            newArray1[i] = new short[16384];
            newArray2[i] = new byte[16384];
        }
        SplitArray24 splitArray24 = this;
        synchronized (splitArray24) {
            this.array1 = newArray1;
            this.array2 = newArray2;
        }
    }

    public void resizeAndClear(long newSize) {
        int oldNrOfChunks = this.array1.length;
        this.resize(newSize);
        for (int i = 0; i < oldNrOfChunks; ++i) {
            Arrays.fill(this.array1[i], (short)0);
            Arrays.fill(this.array2[i], (byte)0);
        }
    }
}

