/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.util.splitarray;

import java.util.Arrays;

public final class SplitArray32 {
    private static final int LOG_CHUNK_SIZE = 14;
    private static final int CHUNK_SIZE = 16384;
    private int[][] array = new int[0][];
    private long size;

    public SplitArray32() {
    }

    public SplitArray32(long size) {
        this.resize(size);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int get(int index) {
        assert ((long)index < this.size);
        int index1 = index >> 14;
        int index2 = index & 0x3FFF;
        int[] array1 = this.array[index1];
        if (array1 == null) {
            SplitArray32 splitArray32 = this;
            synchronized (splitArray32) {
                array1 = this.array[index1];
                assert (array1 != null);
            }
        }
        return array1[index2];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int get(long index) {
        assert (index < this.size);
        int index1 = (int)(index >> 14);
        int index2 = (int)(index & 0x3FFFL);
        int[] array1 = this.array[index1];
        if (array1 == null) {
            SplitArray32 splitArray32 = this;
            synchronized (splitArray32) {
                array1 = this.array[index1];
                assert (array1 != null);
            }
        }
        return array1[index2];
    }

    public int get(int index, int bitOffset, int nrOfBits) {
        assert ((long)index < this.size);
        assert (nrOfBits <= 32);
        assert (nrOfBits > 0);
        assert (bitOffset + nrOfBits <= 32);
        return this.get(index) >>> bitOffset & (1 << nrOfBits) - 1;
    }

    public int get(long index, int bitOffset, int nrOfBits) {
        assert (index < this.size);
        assert (nrOfBits <= 32);
        assert (nrOfBits > 0);
        assert (bitOffset + nrOfBits <= 32);
        return this.get(index) >>> bitOffset & (1 << nrOfBits) - 1;
    }

    public void add(int value) {
        long newSize = this.size + 1L;
        if (newSize > (long)(this.array.length * 16384)) {
            this.resize(newSize);
        } else {
            this.size = newSize;
        }
        this.set(newSize - 1L, value);
    }

    public void set(int index, int value) {
        assert ((long)index < this.size);
        int index1 = index >> 14;
        int index2 = index & 0x3FFF;
        this.array[index1][index2] = value;
    }

    public void set(long index, int value) {
        assert (index < this.size);
        int index1 = (int)(index >> 14);
        int index2 = (int)(index & 0x3FFFL);
        this.array[index1][index2] = value;
    }

    public void set(int index, int value, int bitOffset, int nrOfBits) {
        assert ((long)index < this.size);
        assert (nrOfBits <= 32);
        assert (nrOfBits > 0);
        assert (bitOffset + nrOfBits <= 32);
        int index1 = index >> 14;
        int index2 = index & 0x3FFF;
        int newVal = this.array[index1][index2];
        newVal &= ~((1 << nrOfBits) - 1 << bitOffset);
        this.array[index1][index2] = newVal |= (value & (1 << nrOfBits) - 1) << bitOffset;
    }

    public void set(long index, int value, int bitOffset, int nrOfBits) {
        assert (index < this.size);
        assert (nrOfBits <= 32);
        assert (nrOfBits > 0);
        assert (bitOffset + nrOfBits <= 32);
        int index1 = (int)(index >> 14);
        int index2 = (int)(index & 0x3FFFL);
        int newVal = this.array[index1][index2];
        newVal &= ~((1 << nrOfBits) - 1 << bitOffset);
        this.array[index1][index2] = newVal |= (value & (1 << nrOfBits) - 1) << bitOffset;
    }

    public long size() {
        return this.size;
    }

    public int[] toArray() {
        int sz = (int)this.size;
        int[] result = new int[sz];
        for (int i = 0; i < sz; ++i) {
            result[i] = this.get(i);
        }
        return result;
    }

    public void resize(int newSize) {
        if ((long)newSize < this.size) {
            this.size = newSize;
            return;
        }
        this.resize((long)newSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resize(long newSize) {
        if (newSize < this.size) {
            this.size = newSize;
            return;
        }
        this.size = newSize;
        if (newSize <= (long)(this.array.length * 16384)) {
            return;
        }
        int[][] newArray = new int[(int)(newSize + 16384L - 1L) >> 14][];
        System.arraycopy(this.array, 0, newArray, 0, this.array.length);
        for (int i = this.array.length; i < newArray.length; ++i) {
            newArray[i] = new int[16384];
        }
        SplitArray32 splitArray32 = this;
        synchronized (splitArray32) {
            this.array = newArray;
        }
    }

    public void resizeAndClear(long newSize) {
        int oldNrOfChunks = this.array.length;
        this.resize(newSize);
        for (int i = 0; i < oldNrOfChunks; ++i) {
            Arrays.fill(this.array[i], 0);
        }
    }
}

