/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.util.splitarray;

import java.util.Arrays;

public final class SplitArray48 {
    private static final int LOG_CHUNK_SIZE = 14;
    private static final int CHUNK_SIZE = 16384;
    private int[][] array1 = new int[0][];
    private short[][] array2 = new short[0][];
    private long size;

    public SplitArray48() {
    }

    public SplitArray48(long size) {
        this.resize(size);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long get(int index) {
        short[] array21;
        assert ((long)index < this.size);
        int index1 = index >> 14;
        int index2 = index & 0x3FFF;
        int[] array11 = this.array1[index1];
        if (array11 == null) {
            SplitArray48 splitArray48 = this;
            synchronized (splitArray48) {
                array11 = this.array1[index1];
                assert (array11 != null);
            }
        }
        if ((array21 = this.array2[index1]) == null) {
            SplitArray48 splitArray48 = this;
            synchronized (splitArray48) {
                array21 = this.array2[index1];
                assert (array21 != null);
            }
        }
        return ((long)array11[index2] & 0xFFFFFFFFL) << 16 | (long)(array21[index2] & 0xFFFF);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long get(long index) {
        short[] array21;
        assert (index < this.size);
        int index1 = (int)(index >> 14);
        int index2 = (int)(index & 0x3FFFL);
        int[] array11 = this.array1[index1];
        if (array11 == null) {
            SplitArray48 splitArray48 = this;
            synchronized (splitArray48) {
                array11 = this.array1[index1];
                assert (array11 != null);
            }
        }
        if ((array21 = this.array2[index1]) == null) {
            SplitArray48 splitArray48 = this;
            synchronized (splitArray48) {
                array21 = this.array2[index1];
                assert (array21 != null);
            }
        }
        return ((long)array11[index2] & 0xFFFFFFFFL) << 16 | (long)(array21[index2] & 0xFFFF);
    }

    public long get(int index, int bitOffset, int nrOfBits) {
        assert ((long)index < this.size);
        assert (nrOfBits <= 48);
        assert (nrOfBits > 0);
        assert (bitOffset + nrOfBits <= 48);
        return this.get(index) >>> bitOffset & (1L << nrOfBits) - 1L;
    }

    public long get(long index, int bitOffset, int nrOfBits) {
        assert (index < this.size);
        assert (nrOfBits <= 48);
        assert (nrOfBits > 0);
        assert (bitOffset + nrOfBits <= 48);
        return this.get(index) >>> bitOffset & (1L << nrOfBits) - 1L;
    }

    public void set(long index, long value) {
        assert (index < this.size);
        int index1 = (int)(index >> 14);
        int index2 = (int)(index & 0x3FFFL);
        this.array1[index1][index2] = (int)(value >> 16);
        this.array2[index1][index2] = (short)(value & 0xFFFFL);
    }

    public void set(int index, long value, int bitOffset, int nrOfBits) {
        assert ((long)index < this.size);
        assert (nrOfBits <= 48);
        assert (nrOfBits > 0);
        assert (bitOffset + nrOfBits <= 48);
        long newVal = this.get(index);
        newVal &= (1L << nrOfBits) - 1L << bitOffset ^ 0xFFFFFFFFFFFFFFFFL;
        this.set(index, newVal |= (value & (1L << nrOfBits) - 1L) << bitOffset);
    }

    public void set(long index, long value, int bitOffset, int nrOfBits) {
        assert (index < this.size);
        assert (nrOfBits <= 48);
        assert (nrOfBits > 0);
        assert (bitOffset + nrOfBits <= 48);
        long newVal = this.get(index);
        newVal &= (1L << nrOfBits) - 1L << bitOffset ^ 0xFFFFFFFFFFFFFFFFL;
        this.set(index, newVal |= (value & (1L << nrOfBits) - 1L) << bitOffset);
    }

    public void add(long value) {
        long newSize = this.size + 1L;
        if (newSize > (long)(this.array1.length * 16384)) {
            this.resize(newSize);
        } else {
            this.size = newSize;
        }
        this.set(newSize - 1L, value);
    }

    public long size() {
        return this.size;
    }

    public long[] toArray() {
        int sz = (int)this.size;
        long[] result = new long[sz];
        for (int i = 0; i < sz; ++i) {
            result[i] = this.get(i);
        }
        return result;
    }

    public void resize(int newSize) {
        if ((long)newSize < this.size) {
            this.size = newSize;
            return;
        }
        this.resize((long)newSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resize(long newSize) {
        if (newSize < this.size) {
            this.size = newSize;
            return;
        }
        this.size = newSize;
        if (newSize <= (long)(this.array1.length * 16384)) {
            return;
        }
        int[][] newArray1 = new int[(int)(newSize + 16384L - 1L) >> 14][];
        System.arraycopy(this.array1, 0, newArray1, 0, this.array1.length);
        short[][] newArray2 = new short[(int)(newSize + 16384L - 1L) >> 14][];
        System.arraycopy(this.array2, 0, newArray2, 0, this.array2.length);
        for (int i = this.array1.length; i < newArray1.length; ++i) {
            newArray1[i] = new int[16384];
            newArray2[i] = new short[16384];
        }
        SplitArray48 splitArray48 = this;
        synchronized (splitArray48) {
            this.array1 = newArray1;
            this.array2 = newArray2;
        }
    }

    public void resizeAndClear(long newSize) {
        int oldNrOfChunks = this.array1.length;
        this.resize(newSize);
        for (int i = 0; i < oldNrOfChunks; ++i) {
            Arrays.fill(this.array1[i], 0);
            Arrays.fill(this.array2[i], (short)0);
        }
    }
}

