/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.util.splitarray;

import java.util.Arrays;

public final class SplitArray64 {
    private static final int LOG_CHUNK_SIZE = 14;
    private static final int CHUNK_SIZE = 16384;
    private long[][] array = new long[0][];
    private long size;

    public SplitArray64() {
    }

    public SplitArray64(long size) {
        this.resize(size);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long get(int index) {
        assert ((long)index < this.size);
        int index1 = index >> 14;
        int index2 = index & 0x3FFF;
        long[] array1 = this.array[index1];
        if (array1 == null) {
            SplitArray64 splitArray64 = this;
            synchronized (splitArray64) {
                array1 = this.array[index1];
                assert (array1 != null);
            }
        }
        return array1[index2];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long get(long index) {
        assert (index < this.size);
        int index1 = (int)(index >> 14);
        int index2 = (int)(index & 0x3FFFL);
        long[] array1 = this.array[index1];
        if (array1 == null) {
            SplitArray64 splitArray64 = this;
            synchronized (splitArray64) {
                array1 = this.array[index1];
                assert (array1 != null);
            }
        }
        return array1[index2];
    }

    public long get(int index, int bitOffset, int nrOfBits) {
        assert ((long)index < this.size);
        assert (nrOfBits <= 64);
        assert (nrOfBits > 0);
        assert (bitOffset + nrOfBits <= 64);
        return this.get(index) >>> bitOffset & (1L << nrOfBits) - 1L;
    }

    public long get(long index, int bitOffset, int nrOfBits) {
        assert (index < this.size);
        assert (nrOfBits <= 64);
        assert (nrOfBits > 0);
        assert (bitOffset + nrOfBits <= 64);
        return this.get(index) >>> bitOffset & (1L << nrOfBits) - 1L;
    }

    public void add(long value) {
        long newSize = this.size + 1L;
        if (newSize > (long)(this.array.length * 16384)) {
            this.resize(newSize);
        } else {
            this.size = newSize;
        }
        this.set(newSize - 1L, value);
    }

    public void set(long index, long value) {
        assert (index < this.size);
        int index1 = (int)(index >> 14);
        int index2 = (int)(index & 0x3FFFL);
        this.array[index1][index2] = value;
    }

    public void set(int index, long value, int bitOffset, int nrOfBits) {
        assert ((long)index < this.size);
        assert (nrOfBits <= 64);
        assert (nrOfBits > 0);
        assert (bitOffset + nrOfBits <= 64);
        int index1 = index >> 14;
        int index2 = index & 0x3FFF;
        long newVal = this.array[index1][index2];
        newVal &= (1L << nrOfBits) - 1L << bitOffset ^ 0xFFFFFFFFFFFFFFFFL;
        this.array[index1][index2] = newVal |= (value & (1L << nrOfBits) - 1L) << bitOffset;
    }

    public void set(long index, long value, int bitOffset, int nrOfBits) {
        assert (index < this.size);
        assert (nrOfBits <= 64);
        assert (nrOfBits > 0);
        assert (bitOffset + nrOfBits <= 64);
        int index1 = (int)(index >> 14);
        int index2 = (int)(index & 0x3FFFL);
        long newVal = this.array[index1][index2];
        newVal &= (1L << nrOfBits) - 1L << bitOffset ^ 0xFFFFFFFFFFFFFFFFL;
        this.array[index1][index2] = newVal |= (value & (1L << nrOfBits) - 1L) << bitOffset;
    }

    public long size() {
        return this.size;
    }

    public long[] toArray() {
        int sz = (int)this.size;
        long[] result = new long[sz];
        for (int i = 0; i < sz; ++i) {
            result[i] = this.get(i);
        }
        return result;
    }

    public void resize(int newSize) {
        if ((long)newSize < this.size) {
            this.size = newSize;
            return;
        }
        this.resize((long)newSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resize(long newSize) {
        if (newSize < this.size) {
            this.size = newSize;
            return;
        }
        this.size = newSize;
        if (newSize <= (long)(this.array.length * 16384)) {
            return;
        }
        long[][] newArray = new long[(int)(newSize + 16384L - 1L) >> 14][];
        System.arraycopy(this.array, 0, newArray, 0, this.array.length);
        for (int i = this.array.length; i < newArray.length; ++i) {
            newArray[i] = new long[16384];
        }
        SplitArray64 splitArray64 = this;
        synchronized (splitArray64) {
            this.array = newArray;
        }
    }

    public void resizeAndClear(long newSize) {
        int oldNrOfChunks = this.array.length;
        this.resize(newSize);
        for (int i = 0; i < oldNrOfChunks; ++i) {
            Arrays.fill(this.array[i], 0L);
        }
    }
}

