/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.util.splitarray;

import java.util.AbstractList;
import java.util.List;

public final class SplitArrayObject<T> {
    private static final int LOG_CHUNK_SIZE = 14;
    private static final int CHUNK_SIZE = 16384;
    private T[][] array = new Object[0][];
    private int size;

    public SplitArrayObject() {
        this(16384);
    }

    public SplitArrayObject(T initialObject) {
        this(16384, initialObject);
    }

    public SplitArrayObject(int size) {
        this.resize(size);
    }

    public SplitArrayObject(int size, T initialObject) {
        this.resize(size, initialObject);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T get(int index) {
        assert (index >= 0);
        assert (index < this.size);
        int index1 = index >> 14;
        int index2 = index & 0x3FFF;
        T[] array1 = this.array[index1];
        if (array1 == null) {
            SplitArrayObject splitArrayObject = this;
            synchronized (splitArrayObject) {
                array1 = this.array[index1];
                assert (array1 != null);
            }
        }
        return array1[index2];
    }

    public void set(int index, T object) {
        assert (index >= 0);
        assert (index < this.size);
        int index1 = index >> 14;
        int index2 = index & 0x3FFF;
        this.array[index1][index2] = object;
    }

    public void add(T value) {
        int newSize = this.size + 1;
        if (newSize > this.array.length * 16384) {
            this.resize(newSize);
        } else {
            this.size = newSize;
        }
        this.set(newSize - 1, value);
    }

    public int size() {
        return this.size;
    }

    public void clear() {
        this.size = 0;
        this.array = new Object[0][];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resize(int newSize) {
        if (newSize <= this.size) {
            this.size = newSize;
            return;
        }
        this.size = newSize;
        if (newSize <= this.array.length * 16384) {
            return;
        }
        Object[][] newArray = new Object[newSize + 16384 - 1 >> 14][];
        System.arraycopy(this.array, 0, newArray, 0, this.array.length);
        for (int i = this.array.length; i < newArray.length; ++i) {
            newArray[i] = new Object[16384];
        }
        SplitArrayObject splitArrayObject = this;
        synchronized (splitArrayObject) {
            this.array = newArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resize(int newSize, T initialObject) {
        if (newSize < this.size) {
            this.size = newSize;
            return;
        }
        int oldSize = this.size;
        this.size = newSize;
        if (newSize <= this.array.length * 16384) {
            SplitArrayObject splitArrayObject = this;
            synchronized (splitArrayObject) {
                for (int i = oldSize; i < newSize; ++i) {
                    this.set(i, initialObject);
                }
            }
            return;
        }
        Object[][] newArray = new Object[newSize + 16384 - 1 >> 14][];
        System.arraycopy(this.array, 0, newArray, 0, this.array.length);
        for (int i = this.array.length; i < newArray.length; ++i) {
            newArray[i] = new Object[16384];
        }
        SplitArrayObject splitArrayObject = this;
        synchronized (splitArrayObject) {
            this.array = newArray;
            for (int i = oldSize; i < newSize; ++i) {
                this.set(i, initialObject);
            }
        }
    }

    public List<T> asList() {
        return new ListAdapter(this);
    }

    private static class ListAdapter<E>
    extends AbstractList<E> {
        private final SplitArrayObject<E> array;

        public ListAdapter(SplitArrayObject<E> array) {
            this.array = array;
        }

        @Override
        public E get(int index) {
            return this.array.get(index);
        }

        @Override
        public int size() {
            return this.array.size();
        }

        @Override
        public void clear() {
            this.array.clear();
        }
    }
}

