/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.util.threaddump.parser;

import com.sap.jvm.profiling.util.threaddump.parser.lines.ThreadDumpIOLine;
import com.sap.jvm.profiling.util.threaddump.parser.lines.ThreadDumpIdLine;
import com.sap.jvm.profiling.util.threaddump.parser.lines.ThreadDumpLockInfoLine;
import com.sap.jvm.profiling.util.threaddump.parser.lines.ThreadDumpMethodLine;
import com.sap.jvm.profiling.util.threaddump.parser.lines.ThreadDumpMonitorBlockedLine;
import com.sap.jvm.profiling.util.threaddump.parser.lines.ThreadDumpMonitorLine;
import com.sap.jvm.profiling.util.threaddump.parser.lines.ThreadDumpMonitorOwnerLine;
import com.sap.jvm.profiling.util.threaddump.parser.lines.ThreadDumpNameLine;
import com.sap.jvm.profiling.util.threaddump.parser.lines.ThreadDumpSocketInfoLine;
import com.sap.jvm.profiling.util.threaddump.parser.lines.ThreadDumpStateLine;
import com.sap.jvm.profiling.util.threaddump.parser.lines.ThreadDumpSynchronizerLine;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;

public class ThreadDumpLines {
    public ThreadDumpNameLine nameLine;
    public ThreadDumpIdLine idLine;
    public ThreadDumpIOLine ioLine;
    public ThreadDumpStateLine stateLine;
    public Stack<MethodInfo> stack = new Stack();
    public ArrayList<ThreadDumpSynchronizerLine> synchronizers = new ArrayList();
    public List<AdditionalMonitorInfo> additionalMonitorInfos = new ArrayList<AdditionalMonitorInfo>();

    public boolean isValid() {
        for (MethodInfo methodInfo : this.stack) {
            if (methodInfo.frame != null) continue;
            return false;
        }
        return this.nameLine != null;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.nameLine != null) {
            sb.append(this.nameLine);
            sb.append("\n");
        }
        if (this.idLine != null) {
            sb.append(this.idLine);
            sb.append("\n");
        }
        if (this.ioLine != null) {
            sb.append(this.ioLine);
            sb.append("\n");
        }
        if (this.stateLine != null) {
            sb.append(this.stateLine);
            sb.append("\n");
        }
        for (MethodInfo method : this.stack) {
            sb.append(method.frame);
            sb.append("\n");
            if (method.socketInfo != null) {
                sb.append("\t- ");
                sb.append(method.socketInfo);
                sb.append("\n");
            }
            for (ThreadDumpLockInfoLine lockInfo : method.lockInfos) {
                sb.append("\t- ");
                sb.append(lockInfo);
                sb.append("\n");
            }
        }
        for (ThreadDumpSynchronizerLine sync : this.synchronizers) {
            sb.append(sync);
            sb.append("\n");
        }
        return sb.toString();
    }

    public static class AdditionalMonitorInfo {
        private ThreadDumpMonitorLine monitor;
        private ThreadDumpMonitorOwnerLine owner;
        private List<ThreadDumpMonitorBlockedLine> blocked = new ArrayList<ThreadDumpMonitorBlockedLine>();
        private List<ThreadDumpMonitorBlockedLine> waiters = new ArrayList<ThreadDumpMonitorBlockedLine>();

        public void addWaitingThread(ThreadDumpMonitorBlockedLine waitingThread) {
            this.waiters.add(waitingThread);
        }

        public void addBlockedThread(ThreadDumpMonitorBlockedLine blockedThread) {
            this.blocked.add(blockedThread);
        }

        public ThreadDumpMonitorOwnerLine getOwner() {
            return this.owner;
        }

        public void setOwner(ThreadDumpMonitorOwnerLine owner) {
            this.owner = owner;
        }

        public ThreadDumpMonitorLine getMonitor() {
            return this.monitor;
        }

        public void setMonitor(ThreadDumpMonitorLine monitor) {
            this.monitor = monitor;
        }

        public boolean isValid() {
            return this.monitor != null;
        }

        public List<ThreadDumpMonitorBlockedLine> getBlocked() {
            return this.blocked;
        }

        public List<ThreadDumpMonitorBlockedLine> getWaiters() {
            return this.waiters;
        }
    }

    public static class MethodInfo {
        public ThreadDumpMethodLine frame;
        public ThreadDumpSocketInfoLine socketInfo;
        public ArrayList<ThreadDumpLockInfoLine> lockInfos = new ArrayList();
    }
}

