/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.util.threaddump.parser;

import com.sap.jvm.profiling.util.threaddump.parser.ThreadDumpFormatException;
import com.sap.jvm.profiling.util.threaddump.parser.ThreadDumpLines;
import com.sap.jvm.profiling.util.threaddump.parser.lines.ThreadDumpIOLine;
import com.sap.jvm.profiling.util.threaddump.parser.lines.ThreadDumpIdLine;
import com.sap.jvm.profiling.util.threaddump.parser.lines.ThreadDumpLockInfoLine;
import com.sap.jvm.profiling.util.threaddump.parser.lines.ThreadDumpMethodLine;
import com.sap.jvm.profiling.util.threaddump.parser.lines.ThreadDumpMiscLine;
import com.sap.jvm.profiling.util.threaddump.parser.lines.ThreadDumpMonitorBlockedLine;
import com.sap.jvm.profiling.util.threaddump.parser.lines.ThreadDumpMonitorLine;
import com.sap.jvm.profiling.util.threaddump.parser.lines.ThreadDumpMonitorListLine;
import com.sap.jvm.profiling.util.threaddump.parser.lines.ThreadDumpMonitorOwnerLine;
import com.sap.jvm.profiling.util.threaddump.parser.lines.ThreadDumpNameLine;
import com.sap.jvm.profiling.util.threaddump.parser.lines.ThreadDumpSocketInfoLine;
import com.sap.jvm.profiling.util.threaddump.parser.lines.ThreadDumpStateLine;
import com.sap.jvm.profiling.util.threaddump.parser.lines.ThreadDumpSynchronizerLine;
import com.sap.jvm.profiling.util.threaddump.parser.lines.ThreadDumpTimeStampLine;
import com.sap.jvm.profiling.util.threaddump.parser.lines.ThreadDumpVMInfoLine;
import com.sap.jvm.profiling.util.threaddump.parser.lines.ThreadDumpVMStartupLine;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class ThreadDumpStateMachine {
    private ThreadDumpLines curThreadDump = new ThreadDumpLines();
    private ThreadDumpState[] threadStates = new ThreadDumpState[]{new ThreadDumpInfo(), new ThreadInfo(), new ThreadStack(), new ThreadSynchronizer(), new ThreadCompiler(), new ThreadMonitors(), new ThreadFinishMarker()};
    private ThreadDumpState miscLine = new ThreadDumpInfo();
    private boolean parsingThreadDump = false;
    private int curStateIndex;
    private List<ThreadDumpParseEventListener> listeners = new ArrayList<ThreadDumpParseEventListener>();

    public ThreadDumpStateMachine() {
        this.reset();
    }

    public void addListener(ThreadDumpParseEventListener listener) {
        this.listeners.add(listener);
    }

    public void consumeFile(String fileName) {
        for (ThreadDumpParseEventListener listener : this.listeners) {
            listener.onNewThreadDumpFile(fileName);
        }
    }

    public boolean consumeLine(String line, int lineNo) {
        boolean consumed;
        block10: {
            consumed = false;
            if (line.length() == 0) {
                return true;
            }
            String parsedLine = line;
            if (line.startsWith("J ")) {
                parsedLine = parsedLine.substring(2).trim();
            }
            if (parsedLine.length() == 0) {
                return true;
            }
            try {
                if (this.parsingThreadDump) {
                    int lastState = this.curStateIndex;
                    while (!consumed) {
                        consumed = this.threadStates[this.curStateIndex].consumeLine(parsedLine, lineNo);
                        if (consumed) continue;
                        this.curStateIndex = (this.curStateIndex + 1) % this.threadStates.length;
                        if (this.curStateIndex != lastState) continue;
                        break block10;
                    }
                    break block10;
                }
                consumed = this.miscLine.consumeLine(parsedLine, lineNo);
            }
            catch (ThreadDumpFormatException e) {
                for (ThreadDumpParseEventListener listener : this.listeners) {
                    listener.onThreadDumpLineParseError(line, lineNo, e.getMessage());
                }
            }
        }
        if (!consumed) {
            for (ThreadDumpParseEventListener listener : this.listeners) {
                listener.onThreadDumpUnknownLine(line, lineNo);
            }
            consumed = true;
        }
        return consumed;
    }

    public void finish() throws ThreadDumpFormatException {
        this.finishCurrentThreadDumpItem();
    }

    public void reset() {
        this.curThreadDump = new ThreadDumpLines();
        this.curStateIndex = 0;
    }

    public ThreadDumpLines getThreadLines() {
        return this.curThreadDump;
    }

    private void finishCurrentThreadDumpItem() throws ThreadDumpFormatException {
        if (this.curThreadDump != null && this.curThreadDump.nameLine != null) {
            if (!this.curThreadDump.isValid()) {
                throw new ThreadDumpFormatException("incomplete thread definition");
            }
            for (ThreadDumpParseEventListener listener : this.listeners) {
                listener.onThreadDumpStackTraceParsed(this.curThreadDump);
            }
            this.curThreadDump = new ThreadDumpLines();
        }
    }

    private class ThreadFinishMarker
    implements ThreadDumpState {
        private ThreadFinishMarker() {
        }

        @Override
        public boolean consumeLine(String line, int lineNo) throws ThreadDumpFormatException {
            if (ThreadDumpMiscLine.recognizes(line)) {
                ThreadDumpStateMachine.this.finishCurrentThreadDumpItem();
                ThreadDumpStateMachine.this.parsingThreadDump = false;
                return true;
            }
            return false;
        }
    }

    private class ThreadMonitors
    implements ThreadDumpState {
        private boolean monitorsStarted = false;
        private ThreadDumpLines.AdditionalMonitorInfo currentMonitorInfo;
        private boolean parsingBlockedList;
        private boolean parsingWaitersList;

        private ThreadMonitors() {
        }

        private void finishCurrentMonitorInfo() throws ThreadDumpFormatException {
            if (this.currentMonitorInfo != null && this.currentMonitorInfo.isValid() && this.currentMonitorInfo.getOwner() != null) {
                ((ThreadDumpStateMachine)ThreadDumpStateMachine.this).curThreadDump.additionalMonitorInfos.add(this.currentMonitorInfo);
            }
            this.currentMonitorInfo = new ThreadDumpLines.AdditionalMonitorInfo();
            this.parsingBlockedList = false;
            this.parsingWaitersList = false;
        }

        @Override
        public boolean consumeLine(String line, int lineNo) throws ThreadDumpFormatException {
            if (!this.monitorsStarted) {
                this.monitorsStarted = ThreadDumpMonitorListLine.monitorsStart(line);
                return this.monitorsStarted;
            }
            if (ThreadDumpMonitorLine.recognizes(line)) {
                this.finishCurrentMonitorInfo();
                ThreadDumpMonitorLine monitorLine = ThreadDumpMonitorLine.parse(line);
                this.currentMonitorInfo.setMonitor(monitorLine);
                return true;
            }
            if (this.currentMonitorInfo != null && this.currentMonitorInfo.getOwner() == null && ThreadDumpMonitorOwnerLine.recognizes(line)) {
                ThreadDumpMonitorOwnerLine ownerLine = ThreadDumpMonitorOwnerLine.parse(line);
                this.currentMonitorInfo.setOwner(ownerLine);
                return true;
            }
            if (this.parsingBlockedList) {
                if (ThreadDumpMonitorBlockedLine.recognizes(line)) {
                    ThreadDumpMonitorBlockedLine blockedLine = ThreadDumpMonitorBlockedLine.parse(line);
                    this.currentMonitorInfo.addBlockedThread(blockedLine);
                    return true;
                }
                this.parsingBlockedList = false;
            } else if (this.parsingWaitersList) {
                if (ThreadDumpMonitorBlockedLine.recognizes(line)) {
                    ThreadDumpMonitorBlockedLine waitingLine = ThreadDumpMonitorBlockedLine.parse(line);
                    this.currentMonitorInfo.addWaitingThread(waitingLine);
                    return true;
                }
                this.parsingWaitersList = false;
            }
            ThreadDumpMonitorListLine monitorMiscLine = ThreadDumpMonitorListLine.parse(line);
            if (monitorMiscLine != null) {
                switch (monitorMiscLine.getLineType()) {
                    case NULL_OWNER: {
                        assert (this.currentMonitorInfo.getOwner() == null);
                        break;
                    }
                    case RESPONSIBLE: {
                        break;
                    }
                    case SUCCESSOR: {
                        break;
                    }
                    case CXQ: {
                        this.parsingBlockedList = true;
                        break;
                    }
                    case ENTRY: {
                        this.parsingBlockedList = true;
                        break;
                    }
                    case WAITSET: {
                        this.parsingWaitersList = true;
                        break;
                    }
                    case MONITORS_START: {
                        ThreadDumpStateMachine.this.reset();
                        break;
                    }
                    default: {
                        assert (false);
                        break;
                    }
                }
                return true;
            }
            this.finishCurrentMonitorInfo();
            this.monitorsStarted = false;
            ThreadDumpStateMachine.this.finishCurrentThreadDumpItem();
            ThreadDumpStateMachine.this.parsingThreadDump = false;
            return false;
        }
    }

    private class ThreadCompiler
    implements ThreadDumpState {
        private ThreadCompiler() {
        }

        @Override
        public boolean consumeLine(String line, int lineNo) throws ThreadDumpFormatException {
            return line.startsWith("Compiler thread printing unimplemented.");
        }
    }

    private class ThreadSynchronizer
    implements ThreadDumpState {
        private int curPos = 0;
        private final int maxPos = 3;

        private ThreadSynchronizer() {
        }

        @Override
        public boolean consumeLine(String line, int lineNo) throws ThreadDumpFormatException {
            if (this.curPos == 3) {
                this.curPos = 0;
                return false;
            }
            block5: for (int i = 0; i < 3; ++i) {
                switch ((this.curPos + i) % 3) {
                    case 0: {
                        if (!ThreadDumpSynchronizerLine.isThreadDumpSynchronizerHeaderLine(line)) continue block5;
                        if (!((ThreadDumpStateMachine)ThreadDumpStateMachine.this).curThreadDump.synchronizers.isEmpty()) {
                            throw new ThreadDumpFormatException("inconsistent synchronizer line: header after elements");
                        }
                        this.curPos = 1;
                        return true;
                    }
                    case 1: {
                        if (!ThreadDumpSynchronizerLine.recognizes(line)) continue block5;
                        ((ThreadDumpStateMachine)ThreadDumpStateMachine.this).curThreadDump.synchronizers.add(new ThreadDumpSynchronizerLine(line));
                        return true;
                    }
                    case 2: {
                        if (!ThreadDumpSynchronizerLine.isThreadDumpNonSynchronizerLine(line)) continue block5;
                        if (!((ThreadDumpStateMachine)ThreadDumpStateMachine.this).curThreadDump.synchronizers.isEmpty()) {
                            throw new ThreadDumpFormatException("inconsistent synchronizer line: 'empty' after elements");
                        }
                        this.curPos = 3;
                        return true;
                    }
                }
            }
            return false;
        }
    }

    private class ThreadStack
    implements ThreadDumpState {
        private ThreadStack() {
        }

        @Override
        public boolean consumeLine(String line, int lineNo) throws ThreadDumpFormatException {
            boolean consumed = true;
            ThreadDumpMethodLine methodLine = ThreadDumpMethodLine.parse(line);
            if (methodLine != null) {
                ThreadDumpLines.MethodInfo methodInfo = new ThreadDumpLines.MethodInfo();
                methodInfo.frame = methodLine;
                ((ThreadDumpStateMachine)ThreadDumpStateMachine.this).curThreadDump.stack.push(methodInfo);
            } else if (ThreadDumpLockInfoLine.recognizes(line)) {
                if (((ThreadDumpStateMachine)ThreadDumpStateMachine.this).curThreadDump.stack.empty()) {
                    throw new ThreadDumpFormatException("lock info line without method line");
                }
                ThreadDumpLines.MethodInfo methodInfo = ((ThreadDumpStateMachine)ThreadDumpStateMachine.this).curThreadDump.stack.peek();
                methodInfo.lockInfos.add(new ThreadDumpLockInfoLine(line));
            } else if (ThreadDumpSocketInfoLine.recognizes(line)) {
                if (((ThreadDumpStateMachine)ThreadDumpStateMachine.this).curThreadDump.stack.empty()) {
                    throw new ThreadDumpFormatException("socket info line without method line");
                }
                ThreadDumpLines.MethodInfo methodInfo = ((ThreadDumpStateMachine)ThreadDumpStateMachine.this).curThreadDump.stack.peek();
                if (methodInfo.socketInfo != null) {
                    throw new ThreadDumpFormatException("duplicate socket info line");
                }
                methodInfo.socketInfo = new ThreadDumpSocketInfoLine(line);
            } else {
                consumed = false;
            }
            return consumed;
        }
    }

    private class ThreadInfo
    implements ThreadDumpState {
        private int curPos = 0;
        private final int maxPos = 4;

        private ThreadInfo() {
        }

        @Override
        public boolean consumeLine(String line, int lineNo) throws ThreadDumpFormatException {
            if (this.curPos == 4) {
                this.curPos = 0;
                return false;
            }
            block6: for (int i = 0; i < 4; ++i) {
                switch ((this.curPos + i) % 4) {
                    case 0: {
                        if (!ThreadDumpNameLine.recognizes(line)) continue block6;
                        ThreadDumpStateMachine.this.finishCurrentThreadDumpItem();
                        ((ThreadDumpStateMachine)ThreadDumpStateMachine.this).curThreadDump.nameLine = new ThreadDumpNameLine(line);
                        this.curPos = 1;
                        return true;
                    }
                    case 1: {
                        if (!ThreadDumpIOLine.recognizes(line)) continue block6;
                        if (((ThreadDumpStateMachine)ThreadDumpStateMachine.this).curThreadDump.ioLine != null) {
                            throw new ThreadDumpFormatException("duplicate io line");
                        }
                        ((ThreadDumpStateMachine)ThreadDumpStateMachine.this).curThreadDump.ioLine = new ThreadDumpIOLine(line);
                        this.curPos = 2;
                        return true;
                    }
                    case 2: {
                        if (!ThreadDumpIdLine.recognizes(line)) continue block6;
                        if (((ThreadDumpStateMachine)ThreadDumpStateMachine.this).curThreadDump.idLine != null) {
                            throw new ThreadDumpFormatException("duplicate id line");
                        }
                        ((ThreadDumpStateMachine)ThreadDumpStateMachine.this).curThreadDump.idLine = new ThreadDumpIdLine(line);
                        this.curPos = 3;
                        return true;
                    }
                    case 3: {
                        if (!ThreadDumpStateLine.recognizes(line)) continue block6;
                        if (((ThreadDumpStateMachine)ThreadDumpStateMachine.this).curThreadDump.stateLine != null) {
                            throw new ThreadDumpFormatException("duplicate state line");
                        }
                        ((ThreadDumpStateMachine)ThreadDumpStateMachine.this).curThreadDump.stateLine = new ThreadDumpStateLine(line);
                        this.curPos = 4;
                        return true;
                    }
                }
            }
            return false;
        }
    }

    private class ThreadDumpInfo
    implements ThreadDumpState {
        private ThreadDumpInfo() {
        }

        @Override
        public boolean consumeLine(String line, int lineNo) throws ThreadDumpFormatException {
            if (ThreadDumpTimeStampLine.recognizes(line)) {
                ThreadDumpStateMachine.this.finishCurrentThreadDumpItem();
                ThreadDumpTimeStampLine timestamp = new ThreadDumpTimeStampLine(line);
                for (ThreadDumpParseEventListener listener : ThreadDumpStateMachine.this.listeners) {
                    listener.onThreadDumpStart(timestamp);
                }
                ThreadDumpStateMachine.this.parsingThreadDump = true;
                ThreadDumpStateMachine.this.curStateIndex = 0;
                return true;
            }
            if (ThreadDumpVMInfoLine.recognizes(line)) {
                ThreadDumpVMInfoLine vminfo = new ThreadDumpVMInfoLine(line);
                for (ThreadDumpParseEventListener listener : ThreadDumpStateMachine.this.listeners) {
                    listener.onThreadDumpVmInfo(vminfo);
                }
                ThreadDumpStateMachine.this.parsingThreadDump = true;
                ThreadDumpStateMachine.this.curStateIndex = 0;
                return true;
            }
            if (ThreadDumpVMStartupLine.recognizes(line)) {
                for (ThreadDumpParseEventListener listener : ThreadDumpStateMachine.this.listeners) {
                    try {
                        listener.onThreadDumpVmStartup();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                ThreadDumpStateMachine.this.parsingThreadDump = false;
                ThreadDumpStateMachine.this.curStateIndex = 0;
                return true;
            }
            return false;
        }
    }

    private static interface ThreadDumpState {
        public boolean consumeLine(String var1, int var2) throws ThreadDumpFormatException;
    }

    public static interface ThreadDumpParseEventListener {
        public void onThreadDumpVmStartup() throws IOException, ThreadDumpFormatException;

        public void onThreadDumpStart(ThreadDumpTimeStampLine var1);

        public void onThreadDumpEnd();

        public void onThreadDumpVmInfo(ThreadDumpVMInfoLine var1);

        public void onThreadDumpStackTraceParsed(ThreadDumpLines var1);

        public void onThreadDumpUnknownLine(String var1, int var2);

        public void onThreadDumpLineParseError(String var1, int var2, String var3);

        public void onNewThreadDumpFile(String var1);
    }
}

