/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.util.threaddump.parser.lines;

import com.sap.jvm.profiling.util.threaddump.parser.ThreadDumpFormatException;
import com.sap.jvm.profiling.util.threaddump.parser.lines.ExpressionBase;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class Expression
implements ExpressionBase {
    public static final Regex CHARACTERS0 = new Regex(".*");
    public static final Regex CHARACTERS = new Regex(".+?");
    public static final Regex NUMBER_FLOAT = new Regex("-?\\d+\\.?\\d*");
    public static final Regex WHITESPACES1 = new Regex("\\s+");
    public static final Regex WHITESPACES0 = new Regex("\\s*");
    public static final Regex STRING = new Regex("\\S+?");
    public static final Regex NUMBER = new Regex("-?\\d+");
    public static final Regex NUMBER1 = new Regex("\\d");
    public static final Regex NUMBER2 = new Regex("\\d{2}");
    public static final Regex NUMBER4 = new Regex("\\d{4}");
    public static final Regex FLOAT = new Regex("-?\\d+\\.\\d+");
    public static final Regex HEXNUMBER = new Regex("0x[\\da-fA-F]+");
    public static final Regex MEMORYUNIT = new Regex("(B|KB|MB|GB)");
    public static final Regex NAME = new Regex("[^\\(\\)\\s]+");
    public static final Regex NAME_OR_EMPTY = new Regex("[^\\(\\)\\s]*");
    private final Pattern pattern;
    private final String example;
    private final Map<String, Value<?>> values = new HashMap();
    private ExpressionBase[] expressions;
    private int groupId = 0;
    private int optionalScope = 0;

    protected int incGroupId() {
        return ++this.groupId;
    }

    protected void incOptional() {
        ++this.optionalScope;
    }

    protected void decOptional() {
        --this.optionalScope;
    }

    protected boolean isOptional() {
        return this.optionalScope > 0;
    }

    static ExpressionBase[] convertExpressions(Object ... specification) {
        ExpressionBase[] result = new ExpressionBase[specification.length];
        for (int i = 0; i < specification.length; ++i) {
            Object spec = specification[i];
            ExpressionBase expression = null;
            expression = spec.getClass() == String.class ? new Token((String)spec) : (spec.getClass() == Character.class ? new Token(((Character)spec).toString()) : (ExpressionBase)spec);
            result[i] = expression;
        }
        return result;
    }

    private void setValue(String id, Value<?> val) {
        this.values.put(id, val);
    }

    public Expression(String example, Object ... specification) {
        this.expressions = Expression.convertExpressions(specification);
        String regex = this.createRegex(this);
        this.pattern = Pattern.compile(regex, 2);
        this.example = example;
    }

    public Value<?> getValue(String id) {
        return this.values.get(id);
    }

    public Matcher find(String line) {
        Matcher m = this.pattern.matcher(line);
        if (m.find()) {
            return m;
        }
        return null;
    }

    public Matcher match(String line) throws ThreadDumpFormatException {
        Matcher m = this.find(line);
        if (m != null) {
            return m;
        }
        throw new ThreadDumpFormatException(line, this.example);
    }

    public Matcher matches(String line) {
        Matcher m = this.pattern.matcher(line);
        if (m.matches()) {
            return m;
        }
        return null;
    }

    public boolean findRelaxed(String line) {
        return this.find(line) != null;
    }

    @Override
    public String createRegex(Expression parent) {
        StringBuilder regexBuilder = new StringBuilder();
        for (ExpressionBase expression : this.expressions) {
            regexBuilder.append(expression.createRegex(parent));
        }
        return regexBuilder.toString();
    }

    public static class Optional
    implements ExpressionBase {
        ExpressionBase[] expressions;

        public Optional(Object ... expressions) {
            this.expressions = Expression.convertExpressions(expressions);
        }

        @Override
        public String createRegex(Expression parent) {
            parent.incGroupId();
            parent.incOptional();
            StringBuilder regexBuilder = new StringBuilder();
            regexBuilder.append('(');
            for (ExpressionBase expression : this.expressions) {
                regexBuilder.append(expression.createRegex(parent));
            }
            regexBuilder.append(")?");
            parent.decOptional();
            return regexBuilder.toString();
        }
    }

    public static class Options
    implements ExpressionBase {
        private ExpressionBase[] options;

        public Options(Object ... options) {
            this.options = Expression.convertExpressions(options);
        }

        @Override
        public String createRegex(Expression parent) {
            parent.incGroupId();
            StringBuilder regexBuilder = new StringBuilder();
            regexBuilder.append(WHITESPACES0.getRegex());
            regexBuilder.append('(');
            for (int i = 0; i < this.options.length; ++i) {
                if (i != 0) {
                    regexBuilder.append('|');
                }
                regexBuilder.append(this.options[i].createRegex(parent));
            }
            regexBuilder.append(')');
            regexBuilder.append(WHITESPACES0.getRegex());
            return regexBuilder.toString();
        }
    }

    public static class Value<T>
    implements ExpressionBase {
        private final String id;
        private final ExpressionBase[] expressions;
        private int groupId;
        private boolean isOptional;
        private final Constructor<T> ctor;

        public Value(String id, Class<T> clazz, Object ... expressions) {
            this.id = id;
            this.expressions = Expression.convertExpressions(expressions);
            try {
                this.ctor = clazz.getConstructor(String.class);
            }
            catch (SecurityException e) {
                throw new RuntimeException("Expected a String-constructor for Value of " + clazz);
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException("Expected a String-constructor for Value of " + clazz);
            }
        }

        private Value(String id, int groupId, boolean isOptional, Constructor<T> ctor) {
            this.id = id;
            this.groupId = groupId;
            this.isOptional = isOptional;
            this.ctor = ctor;
            this.expressions = null;
        }

        public Value(String id, Object expression, Class<T> clazz) {
            this(id, clazz, expression);
        }

        public T getValue(Matcher m) throws ThreadDumpFormatException {
            String valueStr = m.group(this.groupId);
            if (valueStr == null && this.isOptional) {
                return null;
            }
            try {
                return this.ctor.newInstance(valueStr);
            }
            catch (IllegalArgumentException e) {
                throw new ThreadDumpFormatException(String.format("Could not convert %s to a %s. Reason: %s", valueStr, this.ctor.getDeclaringClass().getName(), e.getMessage()));
            }
            catch (InstantiationException e) {
                throw new ThreadDumpFormatException(String.format("Could not convert %s to a %s. Reason: %s", valueStr, this.ctor.getDeclaringClass().getName(), e.getMessage()));
            }
            catch (IllegalAccessException e) {
                throw new ThreadDumpFormatException(String.format("Could not convert %s to a %s. Reason: %s", valueStr, this.ctor.getDeclaringClass().getName(), e.getMessage()));
            }
            catch (InvocationTargetException e) {
                throw new ThreadDumpFormatException(String.format("Could not convert %s to a %s. Reason: %s", valueStr, this.ctor.getDeclaringClass().getName(), e.getMessage()));
            }
        }

        @Override
        public String createRegex(Expression parent) {
            int exprGroupId = parent.incGroupId();
            boolean exprIsOptional = parent.isOptional();
            Value<T> val = new Value<T>(this.id, exprGroupId, exprIsOptional, this.ctor);
            parent.setValue(this.id, val);
            StringBuilder regexBuilder = new StringBuilder();
            regexBuilder.append(WHITESPACES0.getRegex());
            regexBuilder.append('(');
            for (ExpressionBase expression : this.expressions) {
                regexBuilder.append(expression.createRegex(parent));
            }
            regexBuilder.append(')');
            regexBuilder.append(WHITESPACES0.getRegex());
            return regexBuilder.toString();
        }
    }

    public static class Token
    implements ExpressionBase {
        private String token;
        private static final String escapeChars = "()[]";

        public Token(String token) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < token.length(); ++i) {
                char cur = token.charAt(i);
                if (escapeChars.indexOf(cur) != -1) {
                    sb.append('\\');
                }
                sb.append(cur);
            }
            this.token = sb.toString();
        }

        @Override
        public String createRegex(Expression parent) {
            String[] parts = this.token.split(WHITESPACES1.getRegex());
            StringBuilder regexBuilder = new StringBuilder();
            regexBuilder.append(WHITESPACES0.getRegex());
            for (int i = 0; i < parts.length; ++i) {
                String part = parts[i];
                regexBuilder.append(part);
                if (i >= parts.length - 1) continue;
                regexBuilder.append(WHITESPACES1.getRegex());
            }
            regexBuilder.append(WHITESPACES0.getRegex());
            return regexBuilder.toString();
        }
    }

    public static class Regex
    implements ExpressionBase {
        private String regex;

        public Regex(String regex) {
            this.regex = regex;
        }

        @Override
        public String createRegex(Expression parent) {
            for (int i = 0; i < this.regex.length(); ++i) {
                if (this.regex.charAt(i) != '(' || i != 0 && this.regex.charAt(i - 1) == '\\') continue;
                parent.incGroupId();
            }
            return this.regex;
        }

        public String getRegex() {
            return this.createRegex(null);
        }
    }

    public static class MemoryNumber {
        private long valueBytes;
        private static final String NUMBER_ID = "NUMBER";
        private static final String MEMORY_ID = "MEMORY";
        public static final Expression memoryExpr = new Expression("234234.04 KB", new Value<Double>("NUMBER", NUMBER_FLOAT, Double.class), WHITESPACES1, new Value<String>("MEMORY", MEMORYUNIT, String.class));

        public MemoryNumber(String valueParts) throws ThreadDumpFormatException {
            Matcher m = memoryExpr.match(valueParts);
            Double floatValueBytes = (Double)memoryExpr.getValue(NUMBER_ID).getValue(m);
            String unit = ((String)memoryExpr.getValue(MEMORY_ID).getValue(m)).toUpperCase();
            long factor = 1L;
            if (!unit.equals("B")) {
                if (unit.equals("KB")) {
                    factor = 1000L;
                } else if (unit.equals("MB")) {
                    factor = 1000000L;
                } else if (unit.equals("GB")) {
                    factor = 1000000000L;
                } else {
                    throw new ThreadDumpFormatException(String.format("Cannot convert %s to a number of bytes: %s is not a known unit.", valueParts, unit));
                }
            }
            this.valueBytes = Math.round(floatValueBytes * (double)factor);
        }

        public long getValue() {
            return this.valueBytes;
        }
    }

    public static class HexNumber {
        private final long value;

        public HexNumber(String number) {
            String strippedNumber = number;
            if (strippedNumber.startsWith("0x")) {
                strippedNumber = strippedNumber.substring(2);
            }
            if (strippedNumber.length() == 16) {
                long msb = Long.parseLong(strippedNumber.substring(0, 8), 16);
                long lsb = Long.parseLong(strippedNumber.substring(8, 16), 16);
                this.value = msb << 32 | lsb;
            } else {
                this.value = Long.parseLong(strippedNumber, 16);
            }
        }

        public long getValue() {
            return this.value;
        }
    }
}

