/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.util.threaddump.parser.lines;

import com.sap.jvm.profiling.util.threaddump.parser.ThreadDumpFormatException;
import com.sap.jvm.profiling.util.threaddump.parser.lines.Expression;
import java.util.regex.Matcher;

public class ThreadDumpIOLine {
    private static final String FILEIO_ID = "FILEIO";
    private static final String NETIO_ID = "NETIO";
    private static final String FILESOPEN_ID = "FILESOPEN";
    private static final String SOCKSSOPEN_ID = "SOCKSOPEN";
    private static Expression ioValuesExp = new Expression("file i/o: 0/0 B, net i/o: 0/0 B, files opened:0, socks opened:0", "file", Expression.WHITESPACES1, "i/o", Character.valueOf(':'), new Expression.Value<BytesTuple>("FILEIO", BytesTuple.bytesTupleExpr, BytesTuple.class), Character.valueOf(','), "net", Expression.WHITESPACES1, "i/o", Character.valueOf(':'), new Expression.Value<BytesTuple>("NETIO", BytesTuple.bytesTupleExpr, BytesTuple.class), Character.valueOf(','), "files", "opened", Character.valueOf(':'), new Expression.Value<Long>("FILESOPEN", Expression.NUMBER, Long.class), Character.valueOf(','), "socks", "opened", Character.valueOf(':'), new Expression.Value<Long>("SOCKSOPEN", Expression.NUMBER, Long.class));
    private static final String VALUES_ID = "VALUES";
    private static final String RESET_VALUES_ID = "RESET_VALUES";
    private static final String ioLineExample = "io= file i/o: 0/0 B, net i/o: 0/0 B, files opened:0, socks opened:0  [reset file i/o: 0/0 B, net i/o: 0/0 B, files opened:0, socks opened:0 ]";
    private static Expression ioExp = new Expression("io= file i/o: 0/0 B, net i/o: 0/0 B, files opened:0, socks opened:0  [reset file i/o: 0/0 B, net i/o: 0/0 B, files opened:0, socks opened:0 ]", "io", Character.valueOf('='), new Expression.Value<String>("VALUES", ioValuesExp, String.class), new Expression.Optional(Character.valueOf('['), "reset", new Expression.Value<String>("RESET_VALUES", ioValuesExp, String.class), Character.valueOf(']')));
    private long[] fileBytes = new long[2];
    private long[] fileBytesReset = new long[2];
    private long[] socketBytes = new long[2];
    private long[] socketBytesReset = new long[2];
    private long numFilesOpen;
    private long numFilesOpenReset;
    private long numSocketsOpen;
    private long numSocketsOpenReset;

    public static ThreadDumpIOLine parse(String line) {
        try {
            ThreadDumpIOLine ioLine = new ThreadDumpIOLine(line);
            return ioLine;
        }
        catch (ThreadDumpFormatException threadDumpFormatException) {
            return null;
        }
    }

    public static boolean recognizes(String line) {
        return ioExp.find(line) != null;
    }

    public ThreadDumpIOLine(String ioLine) throws ThreadDumpFormatException {
        Matcher m = ioExp.match(ioLine);
        String valueLine = (String)ioExp.getValue(VALUES_ID).getValue(m);
        String resetValueLine = (String)ioExp.getValue(RESET_VALUES_ID).getValue(m);
        m = ioValuesExp.match(valueLine);
        this.numFilesOpen = (Long)ioValuesExp.getValue(FILESOPEN_ID).getValue(m);
        this.numSocketsOpen = (Long)ioValuesExp.getValue(SOCKSSOPEN_ID).getValue(m);
        this.fileBytes = ((BytesTuple)ioValuesExp.getValue(FILEIO_ID).getValue(m)).getValues();
        this.socketBytes = ((BytesTuple)ioValuesExp.getValue(NETIO_ID).getValue(m)).getValues();
        if (resetValueLine != null) {
            m = ioValuesExp.match(resetValueLine);
            this.numFilesOpenReset = (Long)ioValuesExp.getValue(FILESOPEN_ID).getValue(m);
            this.numSocketsOpenReset = (Long)ioValuesExp.getValue(SOCKSSOPEN_ID).getValue(m);
            this.fileBytesReset = ((BytesTuple)ioValuesExp.getValue(FILEIO_ID).getValue(m)).getValues();
            this.socketBytesReset = ((BytesTuple)ioValuesExp.getValue(NETIO_ID).getValue(m)).getValues();
        }
    }

    public String toString() {
        return String.format("File r/w/o [reset]: %d/%d/%d [%d/%d/%d]\nSocket /r/w/o [reset]: %d/%d/%d [%d/%d/%d]", this.fileBytes[0], this.fileBytes[1], this.numFilesOpen, this.fileBytesReset[0], this.fileBytesReset[1], this.numFilesOpenReset, this.socketBytes[0], this.socketBytes[1], this.numSocketsOpen, this.socketBytesReset[0], this.socketBytesReset[1], this.numSocketsOpenReset);
    }

    public long[] getFileBytes() {
        return this.fileBytes;
    }

    public long[] getSocketBytes() {
        return this.socketBytes;
    }

    public long[] getFileBytesReset() {
        return this.fileBytesReset;
    }

    public long[] getSocketBytesReset() {
        return this.socketBytesReset;
    }

    public long getNumFilesOpen() {
        return this.numFilesOpen;
    }

    public long getNumFilesOpenReset() {
        return this.numFilesOpenReset;
    }

    public long getNumSocketsOpen() {
        return this.numSocketsOpen;
    }

    public long getNumSocketsOpenReset() {
        return this.numSocketsOpenReset;
    }

    static class BytesTuple {
        private long[] valueBytes = new long[2];
        private static final String FIRST_NUMBER_ID = "FIRST_NUMBER";
        private static final String SECOND_NUMBER_ID = "SECOND_NUMBER";
        private static final String MEMORY_ID = "MEMORY";
        public static final Expression bytesTupleExpr = new Expression("234/645 KB", new Expression.Value<Long>("FIRST_NUMBER", Expression.NUMBER, Long.class), Character.valueOf('/'), new Expression.Value<Long>("SECOND_NUMBER", Expression.NUMBER, Long.class), new Expression.Value<String>("MEMORY", Expression.MEMORYUNIT, String.class));

        public BytesTuple(String valueParts) throws ThreadDumpFormatException {
            Matcher m = bytesTupleExpr.match(valueParts);
            this.valueBytes[0] = (Long)bytesTupleExpr.getValue(FIRST_NUMBER_ID).getValue(m);
            this.valueBytes[1] = (Long)bytesTupleExpr.getValue(SECOND_NUMBER_ID).getValue(m);
            String unit = ((String)bytesTupleExpr.getValue(MEMORY_ID).getValue(m)).toUpperCase();
            long factor = 1L;
            if (!unit.equals("B")) {
                if (unit.equals("KB")) {
                    factor = 1000L;
                } else if (unit.equals("MB")) {
                    factor = 1000000L;
                } else if (unit.equals("GB")) {
                    factor = 1000000000L;
                } else {
                    throw new ThreadDumpFormatException(String.format("Cannot convert %s to a number of bytes: %s is not a known unit.", valueParts, unit));
                }
            }
            this.valueBytes[0] = this.valueBytes[0] * factor;
            this.valueBytes[1] = this.valueBytes[1] * factor;
        }

        public long[] getValues() {
            return this.valueBytes;
        }
    }
}

