/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.util.threaddump.parser.lines;

import com.sap.jvm.profiling.util.threaddump.parser.ThreadDumpFormatException;
import com.sap.jvm.profiling.util.threaddump.parser.lines.Expression;
import java.util.regex.Matcher;

public class ThreadDumpIdLine {
    private static final String PRIO_ID = "PRIO";
    private static final Expression prioExpr = new Expression("prio=10", "prio", Character.valueOf('='), new Expression.Value<Integer>("PRIO", Expression.NUMBER, Integer.class));
    private static final String NID_ID = "NID";
    private static final Expression nidExpr = new Expression("nid=0x9e41", "nid", Character.valueOf('='), new Expression.Value<Expression.HexNumber>("NID", Expression.HEXNUMBER, Expression.HexNumber.class));
    private static final String TID_ID = "TID";
    private static final Expression tidExpr = new Expression("tid=0x9e41", "tid", Character.valueOf('='), new Expression.Value<Expression.HexNumber>("TID", Expression.HEXNUMBER, Expression.HexNumber.class));
    private static final String PTHREAD_ID = "PTHREAD";
    private static final Expression pthreadExpr = new Expression("pthread_id=12345", new Expression.Options("pthread_id", "lwp-id"), Character.valueOf('='), new Expression.Value<Long>("PTHREAD", Expression.NUMBER, Long.class));
    int prio;
    long kernelID;
    long nativeID;
    long pthreadID;

    public static ThreadDumpIdLine parse(String line) {
        try {
            ThreadDumpIdLine idLine = new ThreadDumpIdLine(line);
            return idLine;
        }
        catch (ThreadDumpFormatException threadDumpFormatException) {
            return null;
        }
    }

    public static boolean recognizes(String line) {
        return prioExpr.find(line) != null || nidExpr.find(line) != null || tidExpr.find(line) != null;
    }

    public ThreadDumpIdLine(String line) throws ThreadDumpFormatException {
        Matcher m = prioExpr.find(line);
        if (m != null) {
            this.prio = (Integer)prioExpr.getValue(PRIO_ID).getValue(m);
        }
        if ((m = nidExpr.find(line)) != null) {
            this.kernelID = ((Expression.HexNumber)nidExpr.getValue(NID_ID).getValue(m)).getValue();
        }
        if ((m = tidExpr.find(line)) != null) {
            this.nativeID = ((Expression.HexNumber)tidExpr.getValue(TID_ID).getValue(m)).getValue();
        }
        if ((m = pthreadExpr.find(line)) != null) {
            this.pthreadID = (Long)pthreadExpr.getValue(PTHREAD_ID).getValue(m);
        }
    }

    public String toString() {
        return String.format("prio=%d, kernelID=%d, pthreadID=%d", this.prio, this.kernelID, this.pthreadID);
    }

    public int getPrio() {
        return this.prio;
    }

    public long getKernelID() {
        return this.kernelID;
    }

    public long getNativeID() {
        return this.nativeID;
    }

    public long getPthreadID() {
        return this.pthreadID;
    }
}

