/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.util.threaddump.parser.lines;

import com.sap.jvm.profiling.util.threaddump.parser.ThreadDumpFormatException;
import com.sap.jvm.profiling.util.threaddump.parser.lines.Expression;
import java.util.regex.Matcher;

public class ThreadDumpLockInfoLine {
    private static final String LOCK_USAGE_ID = "LOCKUSAGE";
    private static final String LOCK_ADDRESS_ID = "LOCKADDRESS";
    private static final String LOCK_CLASS_ID = "LOCKCLASS";
    private static final String CLASS_LOCK_ID = "CLASSLOCK";
    private static final Expression lockExpr = new Expression("- waiting on <0x00007f6e5b4f00e8> (a java.lang.Object loader id 6145)", Character.valueOf('-'), new Expression.Value<LockInfoConverter>("LOCKUSAGE", Expression.CHARACTERS, LockInfoConverter.class), Character.valueOf('<'), new Expression.Value<Expression.HexNumber>("LOCKADDRESS", Expression.HEXNUMBER, Expression.HexNumber.class), Character.valueOf('>'), Character.valueOf('('), Character.valueOf('a'), new Expression.Value<String>("CLASSLOCK", new Expression.Optional("java.lang.Class", "for"), String.class), new Expression.Value<String>("LOCKCLASS", Expression.NAME, String.class), new Expression.Optional("loader", "id", Expression.NUMBER), Character.valueOf(')'));
    private static final Expression eliminatedExpr = new Expression("- eliminated <owner is scalar replaced>", Character.valueOf('-'), "eliminated", Character.valueOf('<'), "owner is scalar replaced", Character.valueOf('>'));
    private final long lockAddress;
    private final String lockClass;
    private final LockInfo lockInfo;

    public static ThreadDumpLockInfoLine parse(String line) {
        try {
            ThreadDumpLockInfoLine infoLine = new ThreadDumpLockInfoLine(line);
            return infoLine;
        }
        catch (ThreadDumpFormatException threadDumpFormatException) {
            return null;
        }
    }

    public static boolean recognizes(String line) {
        return lockExpr.findRelaxed(line) || eliminatedExpr.findRelaxed(line);
    }

    public ThreadDumpLockInfoLine(String infoLine) throws ThreadDumpFormatException {
        Matcher m = eliminatedExpr.find(infoLine);
        if (m != null) {
            this.lockAddress = -1L;
            this.lockClass = null;
            this.lockInfo = null;
            return;
        }
        m = lockExpr.match(infoLine);
        this.lockAddress = ((Expression.HexNumber)lockExpr.getValue(LOCK_ADDRESS_ID).getValue(m)).getValue();
        String tmpLockClass = (String)lockExpr.getValue(LOCK_CLASS_ID).getValue(m);
        String value = (String)lockExpr.getValue(CLASS_LOCK_ID).getValue(m);
        if (value != null && value.length() > 0) {
            tmpLockClass = tmpLockClass + ".class";
        }
        this.lockClass = tmpLockClass;
        LockInfo info = ((LockInfoConverter)lockExpr.getValue(LOCK_USAGE_ID).getValue(m)).getValue();
        this.lockInfo = info.equals((Object)LockInfo.ELIMINATED) ? LockInfo.UNKNOWN : info;
    }

    public long getLockAddress() {
        return this.lockAddress;
    }

    public String getLockClass() {
        return this.lockClass;
    }

    public LockInfo getLockInfo() {
        return this.lockInfo;
    }

    public boolean hasLockInfo() {
        return this.lockClass != null && this.lockAddress >= 0L;
    }

    public String toString() {
        if (this.hasLockInfo()) {
            return String.format("%s %s [%d]", this.lockInfo.getText(), this.lockClass, this.lockAddress);
        }
        return "eliminated <owner is scalar replaced>";
    }

    static class LockInfoConverter {
        private final LockInfo lockInfo;

        public LockInfoConverter(String value) throws ThreadDumpFormatException {
            LockInfo result = LockInfo.find(value.toLowerCase());
            if (result == null) {
                throw new ThreadDumpFormatException(String.format("Could not convert '%s' to a valid com.sap.jvm.profiling.util.threaddump.parser.lines.ThreadDumpLockInfoLine.LockInfo", value));
            }
            this.lockInfo = result;
        }

        public LockInfo getValue() {
            return this.lockInfo;
        }
    }

    public static enum LockInfo {
        BLOCKED("waiting to lock"),
        WAITING("waiting on"),
        LOCKING("locked"),
        RELOCKING("waiting to re-lock in wait()"),
        PARKED("parking to wait for"),
        ELIMINATED("eliminated"),
        UNKNOWN("unknown");

        private final String text;

        public static LockInfo find(String value) {
            for (LockInfo info : LockInfo.values()) {
                if (!info.getText().equals(value)) continue;
                return info;
            }
            return null;
        }

        private LockInfo(String text) {
            this.text = text;
        }

        public String getText() {
            return this.text;
        }
    }
}

