/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.util.threaddump.parser.lines;

import com.sap.jvm.profiling.util.threaddump.parser.ThreadDumpFormatException;
import com.sap.jvm.profiling.util.threaddump.parser.lines.Expression;
import java.util.regex.Matcher;

public class ThreadDumpMethodLine {
    private static final String methodExample = "at java.util.concurrent.locks.LockSupport.parkNanos(Ljava/lang/Object;J)V(LockSupport.java:198)";
    private static final String methodExampleAlt = "at com.sap.twogo.scheduler.Scheduler$SchedulerTimerTask.run(Scheduler.java:95)";
    private static final String METHOD_NAME_ID = "METHOD_NAME";
    private static final String METHOD_SIGNATURE_ID = "METHOD_SIGNATURE";
    private static final String METHOD_RETURNTYPE_ID = "METHOD_RETURNTYPE";
    private static final String METHOD_LOCATION_ID = "FILELOCATION";
    private static final Expression methodExpr = new Expression("at java.util.concurrent.locks.LockSupport.parkNanos(Ljava/lang/Object;J)V(LockSupport.java:198)", "at", Expression.WHITESPACES1, new Expression.Value<String>("METHOD_NAME", Expression.NAME, String.class), Character.valueOf('('), new Expression.Value<String>("METHOD_SIGNATURE", Expression.CHARACTERS0, String.class), Character.valueOf(')'), new Expression.Value<String>("METHOD_RETURNTYPE", Expression.NAME_OR_EMPTY, String.class), Character.valueOf('('), new Expression.Value<String>("FILELOCATION", Expression.CHARACTERS, String.class), Character.valueOf(')'));
    private static final Expression methodExprAlt = new Expression("at com.sap.twogo.scheduler.Scheduler$SchedulerTimerTask.run(Scheduler.java:95)", "at", Expression.WHITESPACES1, new Expression.Value<String>("METHOD_NAME", Expression.NAME, String.class), Character.valueOf('('), new Expression.Value<String>("FILELOCATION", Expression.CHARACTERS, String.class), Character.valueOf(')'));
    private static final String FILENAME_ID = "FILELOCATION";
    private static final String LINENUMBER_ID = "LINENUMBER";
    private static final Expression locationExpr = new Expression("LockSupport.java:198", new Expression.Value<String>("FILELOCATION", Expression.NAME, String.class), Character.valueOf(':'), new Expression.Value<Integer>("LINENUMBER", Expression.NUMBER, Integer.class));
    private static final Expression nativeExpr = new Expression("Native Method", "Native Method");
    private String methodName;
    private String methodSignature;
    private String methodReturnType;
    private String fileName;
    private int lineNumber;
    private boolean isNative = false;
    private boolean valid = false;

    public static ThreadDumpMethodLine parse(String line) {
        ThreadDumpMethodLine methodLine = new ThreadDumpMethodLine(line);
        return methodLine.valid ? methodLine : null;
    }

    public static boolean recognizes(String line) {
        return methodExpr.findRelaxed(line);
    }

    public ThreadDumpMethodLine(String methodLine) {
        Expression mExpr = methodExpr;
        Matcher m = methodExpr.find(methodLine);
        boolean useStandardMethodExpression = true;
        if (m == null) {
            m = methodExprAlt.find(methodLine);
            mExpr = methodExprAlt;
            useStandardMethodExpression = false;
        }
        if (m != null) {
            try {
                String location;
                this.methodName = (String)mExpr.getValue(METHOD_NAME_ID).getValue(m);
                if (useStandardMethodExpression) {
                    this.methodSignature = (String)mExpr.getValue(METHOD_SIGNATURE_ID).getValue(m);
                    this.methodReturnType = (String)mExpr.getValue(METHOD_RETURNTYPE_ID).getValue(m);
                } else {
                    this.methodSignature = "LUnknownMethodParameterTypeList;";
                    this.methodReturnType = "LUnknownMethodReturnType;";
                }
                if (this.methodReturnType == null || this.methodReturnType.equals("")) {
                    this.methodReturnType = "LUnknownMethodReturnType;";
                }
                if ((m = locationExpr.find(location = (String)mExpr.getValue("FILELOCATION").getValue(m))) != null) {
                    this.fileName = (String)locationExpr.getValue("FILELOCATION").getValue(m);
                    this.lineNumber = (Integer)locationExpr.getValue(LINENUMBER_ID).getValue(m);
                } else {
                    m = nativeExpr.find(location);
                    this.isNative = m != null;
                }
                this.valid = true;
            }
            catch (ThreadDumpFormatException threadDumpFormatException) {
                // empty catch block
            }
        }
    }

    public String getMethodName() {
        return this.methodName;
    }

    public String getMethodSignature() {
        return this.methodSignature;
    }

    public String getMethodReturnType() {
        return this.methodReturnType;
    }

    public String getFileName() {
        return this.fileName;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public String toString() {
        if (this.fileName != null) {
            return String.format("%s(%s)%s(%s:%d)", this.methodName, this.methodSignature, this.methodReturnType, this.fileName, this.lineNumber);
        }
        return String.format("%s(%s)%s", this.methodName, this.methodSignature, this.methodReturnType);
    }

    public boolean isNative() {
        return this.isNative;
    }
}

