/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.util.threaddump.parser.lines;

import com.sap.jvm.profiling.util.threaddump.parser.ThreadDumpFormatException;
import com.sap.jvm.profiling.util.threaddump.parser.lines.Expression;
import java.util.regex.Matcher;

public class ThreadDumpMonitorBlockedLine {
    private static final String THREAD_NAME_ID = "THREADNAME";
    private static final String TID_ID = "TID";
    private static final Expression expr = new Expression("\"HTTP Worker [@1826502876]\" tid=0x00007f3ed0620000 parked (1) event=-1 notified=false", Character.valueOf('\"'), new Expression.Value<String>("THREADNAME", Expression.CHARACTERS, String.class), Character.valueOf('\"'), "tid", Character.valueOf('='), new Expression.Value<Expression.HexNumber>("TID", Expression.HEXNUMBER, Expression.HexNumber.class), new Expression.Options("parked", "unparked"));
    private String threadName = "";
    private long nativeID;

    public static ThreadDumpMonitorBlockedLine parse(String line) {
        try {
            ThreadDumpMonitorBlockedLine idLine = new ThreadDumpMonitorBlockedLine(line);
            return idLine;
        }
        catch (ThreadDumpFormatException threadDumpFormatException) {
            return null;
        }
    }

    public static boolean recognizes(String line) {
        return expr.find(line) != null;
    }

    public ThreadDumpMonitorBlockedLine(String line) throws ThreadDumpFormatException {
        Matcher m = expr.find(line);
        if (m == null) {
            throw new ThreadDumpFormatException("missing owner expression");
        }
        this.threadName = (String)expr.getValue(THREAD_NAME_ID).getValue(m);
        this.nativeID = ((Expression.HexNumber)expr.getValue(TID_ID).getValue(m)).getValue();
    }

    public String toString() {
        return String.format("blocked thread %s tid = %d", this.threadName, this.nativeID);
    }

    public String getThreadName() {
        return this.threadName;
    }

    public long getNativeID() {
        return this.nativeID;
    }
}

