/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.util.threaddump.parser.lines;

import com.sap.jvm.profiling.util.threaddump.parser.ThreadDumpFormatException;
import com.sap.jvm.profiling.util.threaddump.parser.lines.Expression;
import java.util.regex.Matcher;

public class ThreadDumpMonitorLine {
    private static final String MONITOR_ADDRESS_ID = "MONITORADDRESS";
    private static final String CLASS_LOCK_ID = "CLASSLOCK";
    private static final String MONITOR_CLASS_ID = "MONITORCLASS";
    private static final Expression monitorExpr = new Expression("<0x00007f6e5b4f00e8> (a java.lang.Object)", Character.valueOf('<'), new Expression.Value<Expression.HexNumber>("MONITORADDRESS", Expression.HEXNUMBER, Expression.HexNumber.class), Character.valueOf('>'), Character.valueOf('('), Character.valueOf('a'), new Expression.Value<String>("CLASSLOCK", new Expression.Optional("java.lang.Class", "for"), String.class), new Expression.Value<String>("MONITORCLASS", Expression.NAME, String.class), new Expression.Optional("loader", "id", Expression.NUMBER), Character.valueOf(')'));
    private static final String CONTENDED_MONITOR_ID = "CONT_MONITOR";
    private static final Expression contMonitorExpr = new Expression("contended monitor=0x00007f3e908bafa8", new Expression.Optional("contended"), "monitor", Character.valueOf('='), new Expression.Value<Expression.HexNumber>("CONT_MONITOR", Expression.HEXNUMBER, Expression.HexNumber.class));
    private final long monitorAddress;
    private final String monitorClass;

    public static ThreadDumpMonitorLine parse(String line) {
        try {
            ThreadDumpMonitorLine idLine = new ThreadDumpMonitorLine(line);
            return idLine;
        }
        catch (ThreadDumpFormatException threadDumpFormatException) {
            return null;
        }
    }

    public static boolean recognizes(String line) {
        return monitorExpr.find(line) != null && contMonitorExpr.find(line) != null;
    }

    public ThreadDumpMonitorLine(String line) throws ThreadDumpFormatException {
        Matcher m = monitorExpr.find(line);
        if (m != null) {
            this.monitorAddress = ((Expression.HexNumber)monitorExpr.getValue(MONITOR_ADDRESS_ID).getValue(m)).getValue();
            String className = (String)monitorExpr.getValue(MONITOR_CLASS_ID).getValue(m);
            String value = (String)monitorExpr.getValue(CLASS_LOCK_ID).getValue(m);
            if (value != null && value.length() > 0) {
                className = className + ".class";
            }
            this.monitorClass = className;
        } else {
            this.monitorAddress = 0L;
            this.monitorClass = "";
        }
    }

    public String toString() {
        return String.format("monitor id =%d a %s", this.monitorAddress, this.monitorClass);
    }

    public long getMonitorAddress() {
        return this.monitorAddress;
    }

    public String getMonitorClass() {
        return this.monitorClass;
    }
}

