/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.util.threaddump.parser.lines;

import com.sap.jvm.profiling.util.threaddump.parser.lines.Expression;
import java.util.regex.Matcher;

public class ThreadDumpMonitorListLine {
    private MonitorLineType lineType = MonitorLineType.UNKNOWN;

    public static ThreadDumpMonitorListLine parse(String line) {
        ThreadDumpMonitorListLine monitorLine = new ThreadDumpMonitorListLine(line);
        return monitorLine.lineType != MonitorLineType.UNKNOWN ? monitorLine : null;
    }

    public static boolean monitorsStart(String line) {
        return MonitorLineType.MONITORS_START.getExpr().matches(line) != null;
    }

    public ThreadDumpMonitorListLine(String line) {
        for (MonitorLineType testLineType : MonitorLineType.values()) {
            Matcher m;
            Expression expr = testLineType.getExpr();
            if (expr == null || (m = expr.matches(line)) == null) continue;
            this.lineType = testLineType;
            break;
        }
    }

    public MonitorLineType getLineType() {
        return this.lineType;
    }

    public static enum MonitorLineType {
        NULL_OWNER(new Expression("owner: NULL (0x0000000000000000)", "owner", Character.valueOf(':'), "NULL", Character.valueOf('('), Expression.HEXNUMBER, Character.valueOf(')'))),
        RESPONSIBLE(new Expression("responsible: NULL (0x0000000000000000)", "responsible", Character.valueOf(':'), Expression.CHARACTERS)),
        SUCCESSOR(new Expression("successor: NULL (0x0000000000000000)", "successor", Character.valueOf(':'), Expression.CHARACTERS)),
        CXQ(new Expression("CXQ: Empty", "CXQ", Character.valueOf(':'), new Expression.Optional("Empty"))),
        ENTRY(new Expression("EntryList: | EntryList: Empty", "EntryList", Character.valueOf(':'), new Expression.Optional("Empty"))),
        WAITSET(new Expression("WaitSet (5 waiters): | WaitSet (1 waiter): | WaitSet: Empty", "WaitSet", Character.valueOf('('), Expression.NUMBER, new Expression.Options("waiter", "waiters"), Character.valueOf(')'), Character.valueOf(':'), new Expression.Optional("Empty"))),
        MONITORS_START(new Expression("Monitors:", "Monitors", Character.valueOf(':'))),
        UNKNOWN(null);

        private final Expression expr;

        private MonitorLineType(Expression expr) {
            this.expr = expr;
        }

        public Expression getExpr() {
            return this.expr;
        }
    }
}

