/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.util.threaddump.parser.lines;

import com.sap.jvm.profiling.util.threaddump.parser.ThreadDumpFormatException;
import com.sap.jvm.profiling.util.threaddump.parser.lines.Expression;
import java.util.regex.Matcher;

public class ThreadDumpMonitorOwnerLine {
    private static final String THREAD_NAME_ID = "THREADNAME";
    private static final Expression ownerExpr = new Expression("owner: \"HTTP Worker [@1541071010]\" tid=0x00007f3edcc3f800 unparked (0) event=0", "owner", Character.valueOf(':'), "\"", new Expression.Value<String>("THREADNAME", Expression.CHARACTERS, String.class), "\"");
    private static final String TID_ID = "TID";
    private static final Expression tidExpr = new Expression("tid=0x9e41", "tid", Character.valueOf('='), new Expression.Value<Expression.HexNumber>("TID", Expression.HEXNUMBER, Expression.HexNumber.class));
    private String threadName = "";
    private long nativeID;

    public static ThreadDumpMonitorOwnerLine parse(String line) {
        try {
            ThreadDumpMonitorOwnerLine idLine = new ThreadDumpMonitorOwnerLine(line);
            return idLine;
        }
        catch (ThreadDumpFormatException threadDumpFormatException) {
            return null;
        }
    }

    public static boolean recognizes(String line) {
        return ownerExpr.find(line) != null && tidExpr.find(line) != null;
    }

    public ThreadDumpMonitorOwnerLine(String line) throws ThreadDumpFormatException {
        Matcher m = ownerExpr.find(line);
        if (m == null) {
            throw new ThreadDumpFormatException("missing owner expression");
        }
        this.threadName = (String)ownerExpr.getValue(THREAD_NAME_ID).getValue(m);
        m = tidExpr.find(line);
        if (m == null) {
            throw new ThreadDumpFormatException("missing tid expression");
        }
        this.nativeID = ((Expression.HexNumber)tidExpr.getValue(TID_ID).getValue(m)).getValue();
    }

    public String toString() {
        return String.format("thread %s tid = %d", this.threadName, this.nativeID);
    }

    public String getThreadName() {
        return this.threadName;
    }

    public long getNativeID() {
        return this.nativeID;
    }
}

