/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.util.threaddump.parser.lines;

import com.sap.jvm.profiling.util.threaddump.parser.ThreadDumpFormatException;
import com.sap.jvm.profiling.util.threaddump.parser.lines.Expression;
import java.util.regex.Matcher;

public class ThreadDumpNameLine {
    private static final String THREAD_NAME_ID = "THREAD_NAME";
    private static final Expression nameExpr = new Expression("\"main\"", Character.valueOf('\"'), new Expression.Value<String>("THREAD_NAME", Expression.CHARACTERS, String.class), Character.valueOf('\"'));
    private static final String PRIO_ID = "PRIO";
    private static final Expression prioExpr = new Expression("prio=10", "prio", Character.valueOf('='), new Expression.Value<Integer>("PRIO", Expression.NUMBER, Integer.class));
    private static final String CPU_TIME_ID = "CPU_TIME";
    private static final String CPU_RESET_TIME_ID = "CPU_RESET_TIME";
    private static final Expression cpuExpr = new Expression("cpu=77860.00 [reset 77860.00] ms", "cpu", Character.valueOf('='), new Expression.Value<Double>("CPU_TIME", Expression.FLOAT, Double.class), new Expression.Optional(Character.valueOf('['), "reset", new Expression.Value<Double>("CPU_RESET_TIME", Expression.FLOAT, Double.class), Character.valueOf(']')), "ms");
    private static final String ELAPSED_TIME_ID = "ELAPSED_TIME";
    private static final String ELAPSED_RESET_TIME_ID = "ELAPSED_RESET_TIME";
    private static final Expression elapsedExpr = new Expression("elapsed=77860.00 [reset 77860.00] s", "elapsed", Character.valueOf('='), new Expression.Value<Double>("ELAPSED_TIME", Expression.FLOAT, Double.class), new Expression.Optional(Character.valueOf('['), "reset", new Expression.Value<Double>("ELAPSED_RESET_TIME", Expression.FLOAT, Double.class), Character.valueOf(']')), Character.valueOf('s'));
    private static final String ALLOCATED_ID = "ALLOCATED";
    private static final String ALLOCATED_ID_2 = "ALLOCATED_2";
    private static final String ALLOCATED_RESET_ID = "ALLOCATED_RESET";
    private static final String ALLOCATED_RESET_ID_2 = "ALLOCATED_RESET_2";
    private static final Expression allocatedExpr = new Expression("allocated=4460112440 B (4.15 GB) [reset 4460112440 B (4.15 GB)]", "allocated", new Expression.Optional("memory"), Character.valueOf('='), new Expression.Value<Expression.MemoryNumber>("ALLOCATED", Expression.MemoryNumber.memoryExpr, Expression.MemoryNumber.class), Character.valueOf('('), new Expression.Value<Expression.MemoryNumber>("ALLOCATED_2", Expression.MemoryNumber.memoryExpr, Expression.MemoryNumber.class), Character.valueOf(')'), new Expression.Optional(Character.valueOf('['), "reset", new Expression.Value<Expression.MemoryNumber>("ALLOCATED_RESET", Expression.MemoryNumber.memoryExpr, Expression.MemoryNumber.class), Character.valueOf('('), new Expression.Value<Expression.MemoryNumber>("ALLOCATED_RESET_2", Expression.MemoryNumber.memoryExpr, Expression.MemoryNumber.class), Character.valueOf(')'), Character.valueOf(']')));
    private static final Expression daemonExpr = new Expression("daemon", "daemon");
    private static final String NUMCLASSES_ID = "NUM_CLASSES";
    private static final Expression defineClassExpr = new Expression("defined_classes=12898", "defined_classes", Character.valueOf('='), new Expression.Value<Long>("NUM_CLASSES", Expression.NUMBER, Long.class));
    private final String name;
    private final boolean daemon;
    private final int prio;
    private final long cpuTime;
    private final long cpuTimeReset;
    private final long elapsedTime;
    private final long elapsedTimeReset;
    private final long bytesAllocated;
    private final long bytesAllocatedReset;
    private final long numDefinedClasses;

    static ThreadDumpNameLine parse(String line) {
        try {
            ThreadDumpNameLine nameLine = new ThreadDumpNameLine(line);
            return nameLine;
        }
        catch (ThreadDumpFormatException threadDumpFormatException) {
            return null;
        }
    }

    public static boolean recognizes(String line) {
        return nameExpr.findRelaxed(line) && cpuExpr.findRelaxed(line);
    }

    public ThreadDumpNameLine(String line) throws ThreadDumpFormatException {
        Matcher m = nameExpr.find(line);
        if (m == null) {
            throw new ThreadDumpFormatException("Missing mandatory expression for thread name");
        }
        this.name = (String)nameExpr.getValue(THREAD_NAME_ID).getValue(m);
        this.daemon = daemonExpr.find(line) != null;
        m = prioExpr.find(line);
        this.prio = m != null ? (Integer)prioExpr.getValue(PRIO_ID).getValue(m) : -1;
        m = cpuExpr.find(line);
        this.cpuTime = Math.round(1000000.0 * (Double)cpuExpr.getValue(CPU_TIME_ID).getValue(m));
        Double cpuTimeResetFloat = (Double)cpuExpr.getValue(CPU_RESET_TIME_ID).getValue(m);
        this.cpuTimeReset = cpuTimeResetFloat != null ? Math.round(1000000.0 * cpuTimeResetFloat) : 0L;
        m = elapsedExpr.find(line);
        if (m != null) {
            this.elapsedTime = Math.round(1.0E9 * (Double)elapsedExpr.getValue(ELAPSED_TIME_ID).getValue(m));
            Double elapsedTimeResetFloat = (Double)elapsedExpr.getValue(ELAPSED_RESET_TIME_ID).getValue(m);
            this.elapsedTimeReset = elapsedTimeResetFloat != null ? Math.round(1.0E8 * elapsedTimeResetFloat) : 0L;
        } else {
            this.elapsedTimeReset = 0L;
            this.elapsedTime = 0L;
        }
        m = allocatedExpr.find(line);
        if (m != null) {
            Expression.MemoryNumber bytesAllocatedResetObj2;
            long val1 = ((Expression.MemoryNumber)allocatedExpr.getValue(ALLOCATED_ID).getValue(m)).getValue();
            long val2 = ((Expression.MemoryNumber)allocatedExpr.getValue(ALLOCATED_ID_2).getValue(m)).getValue();
            this.bytesAllocated = Math.max(val1, val2);
            val2 = 0L;
            val1 = 0L;
            Expression.MemoryNumber bytesAllocatedResetObj1 = (Expression.MemoryNumber)allocatedExpr.getValue(ALLOCATED_RESET_ID).getValue(m);
            if (bytesAllocatedResetObj1 != null) {
                val1 = bytesAllocatedResetObj1.getValue();
            }
            if ((bytesAllocatedResetObj2 = (Expression.MemoryNumber)allocatedExpr.getValue(ALLOCATED_RESET_ID_2).getValue(m)) != null) {
                val2 = bytesAllocatedResetObj2.getValue();
            }
            this.bytesAllocatedReset = Math.max(val1, val2);
        } else {
            this.bytesAllocatedReset = 0L;
            this.bytesAllocated = 0L;
        }
        m = defineClassExpr.find(line);
        this.numDefinedClasses = m != null ? (Long)defineClassExpr.getValue(NUMCLASSES_ID).getValue(m) : 0L;
    }

    public String toString() {
        return String.format("Name: '%s' cpu: %d [%d]  elapsed: %d [%d] allocated: %d [%d] defined classes: %d daemon: %s", this.name, this.cpuTime, this.cpuTimeReset, this.elapsedTime, this.elapsedTimeReset, this.bytesAllocated, this.bytesAllocatedReset, this.numDefinedClasses, this.daemon ? "true" : "false");
    }

    public String getName() {
        return this.name;
    }

    public long getCpuTime() {
        return this.cpuTime;
    }

    public long getCpuTimeReset() {
        return this.cpuTimeReset;
    }

    public long getElapsedTime() {
        return this.elapsedTime;
    }

    public long getElapsedTimeReset() {
        return this.elapsedTimeReset;
    }

    public long getBytesAllocated() {
        return this.bytesAllocated;
    }

    public long getBytesAllocatedReset() {
        return this.bytesAllocatedReset;
    }

    public long getNumDefinedClasses() {
        return this.numDefinedClasses;
    }

    public boolean isDaemon() {
        return this.daemon;
    }

    public int getPrio() {
        return this.prio;
    }
}

