/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.util.threaddump.parser.lines;

import com.sap.jvm.profiling.util.threaddump.parser.ThreadDumpFormatException;
import com.sap.jvm.profiling.util.threaddump.parser.lines.Expression;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.regex.Matcher;

public class ThreadDumpSocketInfoLine {
    private static final String socketExample = "- additional info (remote: 10.21.30.50:12345, local: localhost/127.0.0.1:23423)";
    private static final String REMOTE_ID = "REMOTE";
    private static final String LOCAL_ID = "LOCAL";
    private static final Expression socketExpr = new Expression("- additional info (remote: 10.21.30.50:12345, local: localhost/127.0.0.1:23423)", Character.valueOf('-'), "additional", Expression.WHITESPACES1, "info", Character.valueOf('('), "remote", Character.valueOf(':'), new Expression.Value<String>("REMOTE", Expression.STRING, String.class), Character.valueOf(','), "local", Character.valueOf(':'), new Expression.Value<String>("LOCAL", Expression.STRING, String.class), Character.valueOf(')'));
    private static final String ipAddressExample = "10.21.30.50:12345 or ::1:12345";
    private static final String PORT_ID = "PORT";
    private static final String HOSTSPEC_ID = "HOSTSPEC";
    private static final Expression ipAddressExpr = new Expression("10.21.30.50:12345 or ::1:12345", new Expression.Value<String>("HOSTSPEC", Expression.NAME, String.class), Character.valueOf(':'), new Expression.Value<Integer>("PORT", Expression.NUMBER, Integer.class));
    private static final String hostExample = "localhost/127.0.0.1 or localhost/::1";
    private static final String HOSTNAME_ID = "HOSTNAME";
    private static final String IPSTRING_ID = "IPSTRING";
    private static final Expression hostExpr = new Expression("localhost/127.0.0.1 or localhost/::1", new Expression.Value<String>("HOSTNAME", Expression.NAME, String.class), Character.valueOf('/'), new Expression.Value<IPAddressConverter>("IPSTRING", Expression.NAME, IPAddressConverter.class));
    private final SocketData localSocket;
    private final SocketData remoteSocket;

    public static ThreadDumpSocketInfoLine parse(String line) {
        try {
            ThreadDumpSocketInfoLine infoLine = new ThreadDumpSocketInfoLine(line);
            return infoLine;
        }
        catch (ThreadDumpFormatException threadDumpFormatException) {
            return null;
        }
    }

    public static boolean recognizes(String line) {
        return socketExpr.findRelaxed(line);
    }

    private SocketData parseSocket(String socketStr) throws ThreadDumpFormatException {
        Matcher m = ipAddressExpr.match(socketStr);
        int port = (Integer)ipAddressExpr.getValue(PORT_ID).getValue(m);
        String ipAddress = (String)ipAddressExpr.getValue(HOSTSPEC_ID).getValue(m);
        m = hostExpr.find(ipAddress);
        if (m != null) {
            String hostname = (String)hostExpr.getValue(HOSTNAME_ID).getValue(m);
            IPAddress address = ((IPAddressConverter)hostExpr.getValue(IPSTRING_ID).getValue(m)).getAddr();
            return new SocketData(address, hostname, port);
        }
        IPAddress address = new IPAddressConverter(ipAddress).getAddr();
        return new SocketData(address, null, port);
    }

    public ThreadDumpSocketInfoLine(String socketInfoLine) throws ThreadDumpFormatException {
        Matcher m = socketExpr.match(socketInfoLine);
        String localAddr = (String)socketExpr.getValue(LOCAL_ID).getValue(m);
        String remoteAddr = (String)socketExpr.getValue(REMOTE_ID).getValue(m);
        this.localSocket = this.parseSocket(localAddr);
        this.remoteSocket = this.parseSocket(remoteAddr);
    }

    public String toString() {
        return String.format("local: %s, remote: %s", this.localSocket, this.remoteSocket);
    }

    public SocketData getLocalSocket() {
        return this.localSocket;
    }

    public SocketData getRemoteSocket() {
        return this.remoteSocket;
    }

    public static class SocketData {
        private final String hostname;
        private final IPAddress address;
        private final int port;

        public SocketData(IPAddress address, String hostname, int port) {
            this.hostname = hostname;
            this.address = address;
            this.port = port;
        }

        public String toString() {
            return String.format("%s (%s):%d", this.address.toString(), this.hostname != null ? this.hostname : "", this.port);
        }

        public String getHostname() {
            return this.hostname;
        }

        public IPAddress getAddress() {
            return this.address;
        }

        public int getPort() {
            return this.port;
        }
    }

    static class IPAddressConverter {
        private final IPAddress addr;

        public IPAddressConverter(String value) {
            byte[] bytes;
            boolean ipv4;
            String realValue = value;
            boolean bl = ipv4 = realValue.indexOf(46) > 0;
            if (!ipv4) {
                realValue = String.format("[%s]", realValue);
            }
            try {
                bytes = InetAddress.getByName(realValue).getAddress();
            }
            catch (UnknownHostException e) {
                throw new NumberFormatException();
            }
            if (bytes.length == 4) {
                assert (ipv4);
                int ip4addr = (bytes[3] & 0xFF) + ((bytes[2] & 0xFF) << 8) + ((bytes[1] & 0xFF) << 16) + ((bytes[0] & 0xFF) << 24);
                this.addr = new IPAddress(ip4addr);
            } else if (bytes.length == 16) {
                assert (!ipv4);
                long networkPrefix = 0L;
                long hostAddress = 0L;
                int shift = 0;
                for (int i = 7; i >= 0; --i) {
                    networkPrefix += (long)(bytes[i] & 0xFF) << shift;
                    hostAddress += (long)(bytes[i + 8] & 0xFF) << shift;
                    shift += 8;
                }
                this.addr = new IPAddress(networkPrefix, hostAddress);
            } else {
                throw new NumberFormatException();
            }
        }

        public IPAddress getAddr() {
            return this.addr;
        }
    }

    public static class IPAddress {
        boolean isIpv4Addr;
        int addr;
        long networkPrefix;
        long hostAddress;

        public IPAddress(int addr) {
            this.addr = addr;
            this.isIpv4Addr = true;
        }

        public IPAddress(long networkPrefix, long hostAddress) {
            this.networkPrefix = networkPrefix;
            this.hostAddress = hostAddress;
            this.isIpv4Addr = false;
        }

        public String toString() {
            if (this.isIpv4Addr) {
                return (this.addr >> 24 & 0xFF) + "." + (this.addr >> 16 & 0xFF) + "." + (this.addr >> 8 & 0xFF) + "." + (this.addr >> 0 & 0xFF);
            }
            if (this.networkPrefix == 0L && this.hostAddress == 0L) {
                return "::";
            }
            StringBuffer sb = new StringBuffer(39);
            sb.append(Long.toHexString(this.networkPrefix >> 48 & 0xFFFFL));
            sb.append(":");
            sb.append(Long.toHexString(this.networkPrefix >> 32 & 0xFFFFL));
            sb.append(":");
            sb.append(Long.toHexString(this.networkPrefix >> 16 & 0xFFFFL));
            sb.append(":");
            sb.append(Long.toHexString(this.networkPrefix >> 0 & 0xFFFFL));
            sb.append(":");
            sb.append(Long.toHexString(this.hostAddress >> 48 & 0xFFFFL));
            sb.append(":");
            sb.append(Long.toHexString(this.hostAddress >> 32 & 0xFFFFL));
            sb.append(":");
            sb.append(Long.toHexString(this.hostAddress >> 16 & 0xFFFFL));
            sb.append(":");
            sb.append(Long.toHexString(this.hostAddress >> 0 & 0xFFFFL));
            return sb.toString();
        }

        public boolean isIpv4Addr() {
            return this.isIpv4Addr;
        }

        public int getAddr() {
            return this.addr;
        }

        public long getNetworkPrefix() {
            return this.networkPrefix;
        }

        public long getHostAddress() {
            return this.hostAddress;
        }
    }
}

