/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.util.threaddump.parser.lines;

import com.sap.jvm.profiling.util.threaddump.parser.ThreadDumpFormatException;
import com.sap.jvm.profiling.util.threaddump.parser.lines.Expression;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;

public class ThreadDumpStateLine {
    private static final String STATUS_VALUE = "STATUS_VALUE";
    private static Expression threadStateExp = new Expression("java.lang.Thread.State: TIMED_WAITING (on object monitor)", "java.lang.Thread.State", Character.valueOf(':'), new Expression.Value<ThreadStateConverter>("STATUS_VALUE", ThreadStateConverter.threadStateExpr, ThreadStateConverter.class));
    private ThreadState threadStatus;

    public static ThreadDumpStateLine parse(String line) {
        try {
            ThreadDumpStateLine stateLine = new ThreadDumpStateLine(line);
            return stateLine;
        }
        catch (ThreadDumpFormatException threadDumpFormatException) {
            return null;
        }
    }

    public static boolean recognizes(String line) {
        return threadStateExp.findRelaxed(line);
    }

    public ThreadDumpStateLine(String stateLine) throws ThreadDumpFormatException {
        Matcher m = threadStateExp.match(stateLine);
        this.threadStatus = ((ThreadStateConverter)threadStateExp.getValue(STATUS_VALUE).getValue(m)).getThreadState();
    }

    public ThreadState getThreadStatus() {
        return this.threadStatus;
    }

    public String toString() {
        return this.threadStatus.toString();
    }

    static class ThreadStateConverter {
        private final ThreadState threadState;
        static Expression threadStateExpr = new Expression("waiting (on object monitor)", new Expression.Options(ThreadState.getKeys()));

        public ThreadStateConverter(String value) throws ThreadDumpFormatException {
            ThreadState result = ThreadState.find(value.toLowerCase());
            if (result == null) {
                throw new ThreadDumpFormatException(String.format("Could not convert '%s' to a valid com.sap.jvm.profiling.util.threaddump.parser.lines.ThreadDumpStateLine.ThreadState", value));
            }
            this.threadState = result;
        }

        public ThreadState getThreadState() {
            return this.threadState;
        }
    }

    public static enum ThreadState {
        THREAD_STATE_WAIT("waiting (on object monitor)"),
        THREAD_STATE_RUNNABLE("runnable"),
        THREAD_STATE_WAITOBJECTMONITOR("blocked (on object monitor)"),
        THREAD_STATE_SLEEPING("timed_waiting (sleeping)"),
        THREAD_STATE_WAIT_TIMED("timed_waiting (on object monitor)"),
        THREAD_STATE_WAITLOCK("waiting (parking)"),
        THREAD_STATE_WAITLOCK_TIMED("timed_waiting (parking)"),
        THREAD_STATE_NEW("new"),
        THREAD_STATE_TERMINATED("terminated"),
        THREAD_STATE_UNKNOWN("unknown");

        private final String text;
        private static Map<String, ThreadState> values;

        static String[] getKeys() {
            return values.keySet().toArray(new String[0]);
        }

        public static ThreadState find(String key) {
            return values.get(key);
        }

        private ThreadState(String text) {
            this.text = text;
        }

        public String getText() {
            return this.text;
        }

        static {
            values = new HashMap<String, ThreadState>(10);
            for (ThreadState state : ThreadState.values()) {
                values.put(state.getText().toLowerCase(), state);
            }
        }
    }
}

