/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.util.threaddump.parser.lines;

import com.sap.jvm.profiling.util.threaddump.parser.ThreadDumpFormatException;
import com.sap.jvm.profiling.util.threaddump.parser.lines.Expression;
import java.util.regex.Matcher;

public class ThreadDumpSynchronizerLine {
    private static final Expression synchronizerListHeaderExpr = new Expression("Locked ownable synchronizers:", "Locked ownable synchronizers", Character.valueOf(':'));
    private static final Expression emptySynchronizerExpr = new Expression("- None", Character.valueOf('-'), "None");
    private static final String LOCK_ADDRESS_ID = "SYNCADDRESS";
    private static final String LOCK_CLASS_ID = "SYNCCLASS";
    private static final Expression synchronizerExpr = new Expression("- <0xabcd1234> (a java.util.concurrentLock.ReentrantLock$SyncFair)", Character.valueOf('-'), Character.valueOf('<'), new Expression.Value<Expression.HexNumber>("SYNCADDRESS", Expression.HEXNUMBER, Expression.HexNumber.class), Character.valueOf('>'), Character.valueOf('('), Character.valueOf('a'), new Expression.Value<String>("SYNCCLASS", Expression.NAME, String.class), Character.valueOf(')'));
    private final long synchronizerAddress;
    private final String synchronizerClass;

    public static boolean isThreadDumpSynchronizerHeaderLine(String line) {
        return synchronizerListHeaderExpr.find(line) != null;
    }

    public static boolean isThreadDumpNonSynchronizerLine(String line) {
        return emptySynchronizerExpr.find(line) != null;
    }

    public static ThreadDumpSynchronizerLine parse(String line) {
        try {
            ThreadDumpSynchronizerLine syncLine = new ThreadDumpSynchronizerLine(line);
            return syncLine;
        }
        catch (ThreadDumpFormatException threadDumpFormatException) {
            return null;
        }
    }

    public static boolean recognizes(String line) {
        return synchronizerExpr.findRelaxed(line);
    }

    public ThreadDumpSynchronizerLine(String syncLine) throws ThreadDumpFormatException {
        Matcher m = synchronizerExpr.match(syncLine);
        this.synchronizerAddress = ((Expression.HexNumber)synchronizerExpr.getValue(LOCK_ADDRESS_ID).getValue(m)).getValue();
        this.synchronizerClass = (String)synchronizerExpr.getValue(LOCK_CLASS_ID).getValue(m);
    }

    public long getSynchronizerAddress() {
        return this.synchronizerAddress;
    }

    public String getSynchronizerClass() {
        return this.synchronizerClass;
    }

    public String toString() {
        return String.format("a %s [%d]", this.synchronizerClass, this.synchronizerAddress);
    }
}

