/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.util.threaddump.parser.lines;

import com.sap.jvm.profiling.util.threaddump.parser.ThreadDumpFormatException;
import com.sap.jvm.profiling.util.threaddump.parser.lines.Expression;
import java.util.regex.Matcher;

public class ThreadDumpTimeStampLine {
    private static final String YEAR_ID = "YEAR";
    private static final String MONTH_ID = "MONTH";
    private static final String DAY_ID = "DAY";
    private static final String HOUR_ID = "HOUR";
    private static final String MINUTE_ID = "MINUTE";
    private static final String SECOND_ID = "SECOND";
    private static final String signalPrefix = "Thread dump triggered at";
    private static final Expression timeStampExpr = new Expression("Thread dump triggered at 2012-09-27 13:56:02", "Thread dump triggered at", Expression.WHITESPACES1, new Expression.Value<Integer>("YEAR", Integer.class, Expression.NUMBER4), Character.valueOf('-'), new Expression.Value<Integer>("MONTH", Integer.class, Expression.NUMBER2), Character.valueOf('-'), new Expression.Value<Integer>("DAY", Integer.class, Expression.NUMBER2), Expression.WHITESPACES1, new Expression.Value<Integer>("HOUR", Integer.class, Expression.NUMBER2), Character.valueOf(':'), new Expression.Value<Integer>("MINUTE", Integer.class, Expression.NUMBER2), Character.valueOf(':'), new Expression.Value<Integer>("SECOND", Integer.class, Expression.NUMBER2));
    private int year;
    private int month;
    private int day;
    private int hour;
    private int minute;
    private int second;

    static ThreadDumpTimeStampLine parse(String line) {
        try {
            return new ThreadDumpTimeStampLine(line);
        }
        catch (ThreadDumpFormatException threadDumpFormatException) {
            return null;
        }
    }

    public static boolean recognizes(String line) {
        return line.contains(signalPrefix);
    }

    public ThreadDumpTimeStampLine(String timeStampLine) throws ThreadDumpFormatException {
        Matcher m = timeStampExpr.match(timeStampLine);
        this.year = (Integer)timeStampExpr.getValue(YEAR_ID).getValue(m);
        this.month = (Integer)timeStampExpr.getValue(MONTH_ID).getValue(m);
        this.day = (Integer)timeStampExpr.getValue(DAY_ID).getValue(m);
        this.hour = (Integer)timeStampExpr.getValue(HOUR_ID).getValue(m);
        this.minute = (Integer)timeStampExpr.getValue(MINUTE_ID).getValue(m);
        this.second = (Integer)timeStampExpr.getValue(SECOND_ID).getValue(m);
    }

    public String toString() {
        return String.format("Date: %d-%d-%d time: %d:%d:%d", this.year, this.month, this.day, this.hour, this.minute, this.second);
    }

    public int getYear() {
        return this.year;
    }

    public int getMonth() {
        return this.month - 1;
    }

    public int getDay() {
        return this.day;
    }

    public int getHour() {
        return this.hour;
    }

    public int getMinute() {
        return this.minute;
    }

    public int getSecond() {
        return this.second;
    }
}

