/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.util.threaddump.parser.lines;

import com.sap.jvm.profiling.util.threaddump.parser.ThreadDumpFormatException;
import com.sap.jvm.profiling.util.threaddump.parser.lines.Expression;
import java.util.regex.Matcher;

public class ThreadDumpVMInfoLine {
    private static final String vmInfoExample = "Full thread dump SAP Java Server VM (6.1.internal 1.6-b04 Apr 11 2012 19:59:30 - dev - optU - windows amd64 - 6 - bas2:169999 (mixed mode)):";
    private static final String VERSION_ID = "VERSION";
    private static final String DATE_ID = "DATE";
    private static final String TIME_ID = "TIME";
    private static final String CODELINE_ID = "CODELINE";
    private static final String TARGET_ID = "TARGET";
    private static final String PLATFORM_ID = "PLATFORM";
    private static final String HOTSPOT_ID = "HOTSPOT";
    private static final String CHANGELIST_ID = "CHANGELIST";
    private static final String signalPrefix = "Full thread dump SAP Java";
    private static final Expression vmInfoExpr = new Expression("Full thread dump SAP Java Server VM (6.1.internal 1.6-b04 Apr 11 2012 19:59:30 - dev - optU - windows amd64 - 6 - bas2:169999 (mixed mode)):", "Full thread dump SAP Java", new Expression.Optional("64-Bit"), "Server VM", Character.valueOf('('), new Expression.Value<String>("VERSION", String.class, Expression.NUMBER, Character.valueOf('.'), Expression.NUMBER, Character.valueOf('.'), Expression.CHARACTERS), Expression.CHARACTERS, new Expression.Value<String>("DATE", String.class, Expression.NAME, Expression.WHITESPACES1, Expression.NUMBER, Expression.WHITESPACES1, Expression.NUMBER4), Expression.CHARACTERS, new Expression.Value<String>("TIME", String.class, Expression.NUMBER2, Character.valueOf(':'), Expression.NUMBER2, Character.valueOf(':'), Expression.NUMBER2), Character.valueOf('-'), new Expression.Value<String>("CODELINE", String.class, Expression.NAME), Character.valueOf('-'), new Expression.Value<String>("TARGET", String.class, Expression.CHARACTERS), Character.valueOf('-'), new Expression.Value<String>("PLATFORM", String.class, Expression.CHARACTERS), new Expression.Optional(Character.valueOf('-'), new Expression.Value<Integer>("HOTSPOT", Integer.class, Expression.NUMBER)), new Expression.Optional(Character.valueOf('-'), "bas2", Character.valueOf(':'), new Expression.Value<Integer>("CHANGELIST", Integer.class, Expression.NUMBER)), Character.valueOf('('), Expression.CHARACTERS, Character.valueOf(')'), Character.valueOf(')'), Character.valueOf(':'));
    private String vmVersion;
    private String buildDate;
    private String buildTime;
    private String codeline;
    private String buildTarget;
    private String buildPlatform;
    private int hotspotVersion;
    private int changelist;

    static ThreadDumpVMInfoLine parse(String line) {
        try {
            ThreadDumpVMInfoLine infoLine = new ThreadDumpVMInfoLine(line);
            return infoLine;
        }
        catch (ThreadDumpFormatException e) {
            return null;
        }
    }

    public static boolean recognizes(String line) {
        return line.contains(signalPrefix);
    }

    public ThreadDumpVMInfoLine(String vmInfoLine) throws ThreadDumpFormatException {
        Integer changeListVar;
        Matcher m = vmInfoExpr.match(vmInfoLine);
        this.vmVersion = (String)vmInfoExpr.getValue(VERSION_ID).getValue(m);
        this.buildDate = (String)vmInfoExpr.getValue(DATE_ID).getValue(m);
        this.buildTime = (String)vmInfoExpr.getValue(TIME_ID).getValue(m);
        this.codeline = (String)vmInfoExpr.getValue(CODELINE_ID).getValue(m);
        this.buildTarget = (String)vmInfoExpr.getValue(TARGET_ID).getValue(m);
        this.buildPlatform = (String)vmInfoExpr.getValue(PLATFORM_ID).getValue(m);
        Integer hotspotVar = (Integer)vmInfoExpr.getValue(HOTSPOT_ID).getValue(m);
        if (hotspotVar != null) {
            this.hotspotVersion = hotspotVar;
        }
        if ((changeListVar = (Integer)vmInfoExpr.getValue(CHANGELIST_ID).getValue(m)) != null) {
            this.changelist = changeListVar;
        }
    }

    public String toString() {
        return String.format("VM version: %s, Build date: %s, Build time: %s, Build target: %s, Build platform: %s, Codeline: %s, Changelist: %s ", this.vmVersion, this.buildDate, this.buildTime, this.buildTarget, this.buildPlatform, this.codeline, this.changelist);
    }

    public String getVmVersion() {
        return this.vmVersion;
    }

    public String getBuildDate() {
        return this.buildDate;
    }

    public String getBuildTime() {
        return this.buildTime;
    }

    public String getCodeline() {
        return this.codeline;
    }

    public String getBuildTarget() {
        return this.buildTarget;
    }

    public String getBuildPlatform() {
        return this.buildPlatform;
    }

    public int getHotspotVersion() {
        return this.hotspotVersion;
    }

    public int getChangelist() {
        return this.changelist;
    }
}

