/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.session;

import java.security.AccessController;
import java.security.BasicPermission;
import java.security.Permission;

public class SessionPermission
extends BasicPermission {
    private static final long serialVersionUID = -8982866249662064192L;
    private static String performChecksProp;
    public static final boolean IS_PERMISSION_CHECK_REQUIRED;
    public static final SessionPermission SESSION_STORE_PERMISSION;

    public static final void checkPermission(SessionPermission perm) {
        if (!IS_PERMISSION_CHECK_REQUIRED) {
            return;
        }
        AccessController.checkPermission(perm);
    }

    public SessionPermission(String name) {
        super(name);
        if (name == null) {
            throw new NullPointerException("name can't be null");
        }
        if (name.length() == 0) {
            throw new IllegalArgumentException("name can't be empty");
        }
    }

    @Override
    public boolean implies(Permission permission) {
        return this.equals(permission);
    }

    static {
        try {
            performChecksProp = System.getProperty("com.sap.jvm.PerformPermissionChecks");
        }
        catch (SecurityException e) {
            performChecksProp = "true";
        }
        IS_PERMISSION_CHECK_REQUIRED = performChecksProp != null;
        SESSION_STORE_PERMISSION = new SessionPermission("session_store");
    }
}

