/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.session;

import com.sap.jvm.session.OutOfSharedMemoryException;
import com.sap.jvm.session.SharedDataAccessException;
import com.sap.jvm.session.SharedSessionChunk;
import com.sap.jvm.session.SharedSessionDomain;
import com.sap.jvm.session.SharedSessionStore;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.Set;

public class SharedSession {
    private final SharedSessionDomain domain;
    String name;
    private final int handle;

    SharedSession(SharedSessionDomain domain, int handle) {
        this.domain = domain;
        this.handle = handle;
    }

    SharedSession(SharedSessionDomain domain, String name, int handle) {
        this.domain = domain;
        this.name = name;
        this.handle = handle;
    }

    public SharedSessionDomain getDomain() {
        return this.domain;
    }

    public String getName() throws SharedDataAccessException {
        if (this.name == null) {
            this.name = SharedSessionStore.impl.getSessionName(this.handle);
        }
        return this.name;
    }

    int getHandle() {
        return this.handle;
    }

    public long getExpirationTime() throws SharedDataAccessException {
        return SharedSessionStore.impl.getSessionExpirationTime(this.handle);
    }

    public void setExpirationTime(long expirationTime) throws SharedDataAccessException {
        SharedSessionStore.impl.setSessionExpirationTime(this.handle, expirationTime);
    }

    public long getCreationTime() throws SharedDataAccessException {
        return SharedSessionStore.impl.getSessionCreationTime(this.handle);
    }

    public void setCreationTime(long creationTime) throws SharedDataAccessException {
        SharedSessionStore.impl.setSessionCreationTime(this.handle, creationTime);
    }

    public long getTimeoutPeriod() throws SharedDataAccessException {
        return SharedSessionStore.impl.getSessionTimeoutPeriod(this.handle);
    }

    public void setTimeoutPeriod(long timeoutPeriod) throws SharedDataAccessException {
        SharedSessionStore.impl.setSessionTimeoutPeriod(this.handle, timeoutPeriod);
    }

    public long getTotalSize() throws SharedDataAccessException {
        return SharedSessionStore.impl.getSessionTotalSize(this.handle);
    }

    public void destroy() {
        SharedSessionStore.impl.destroySession(this.domain.getHandle(), this.handle);
    }

    public SharedSessionChunk createSharedSessionChunk(String chunkName) throws SharedDataAccessException, OutOfSharedMemoryException {
        int chunkId = SharedSessionStore.impl.createChunk(this.handle, chunkName);
        if (chunkId == -1) {
            return null;
        }
        return new SharedSessionChunk(this, chunkName, chunkId);
    }

    public SharedSessionChunk getSharedSessionChunk(String chunkName) throws SharedDataAccessException {
        int chunkId = SharedSessionStore.impl.getChunk(this.handle, chunkName);
        if (chunkId == -1) {
            return null;
        }
        return new SharedSessionChunk(this, chunkName, chunkId);
    }

    public Set<SharedSessionChunk> chunks() throws SharedDataAccessException {
        final int[] ids = SharedSessionStore.impl.getChunkIds(this.handle);
        return new AbstractSet<SharedSessionChunk>(){

            @Override
            public Iterator<SharedSessionChunk> iterator() {
                return new Iterator<SharedSessionChunk>(){
                    private int idx = 0;

                    @Override
                    public boolean hasNext() {
                        return this.idx < ids.length;
                    }

                    @Override
                    public SharedSessionChunk next() {
                        return new SharedSessionChunk(SharedSession.this, ids[this.idx++]);
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException("remove not supported");
                    }
                };
            }

            @Override
            public int size() {
                return ids.length;
            }
        };
    }
}

