/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.session;

import com.sap.jvm.session.DeserializationCallback;
import com.sap.jvm.session.DeserializationCallbackInterface;
import com.sap.jvm.session.OutOfSharedMemoryException;
import com.sap.jvm.session.SerializationCallback;
import com.sap.jvm.session.SharedDataAccessException;
import com.sap.jvm.session.SharedSession;
import com.sap.jvm.session.SharedSessionStore;
import java.io.IOException;
import java.io.NotActiveException;
import java.io.ObjectStreamClass;

public class SharedSessionChunk {
    private static SerializationCallback defaultSerializationCallback = new SerializationCallback();
    private static DeserializationCallback defaultDeserializationCallback = new DeserializationCallback();
    private final SharedSession session;
    private String name;
    private final int id;
    private DeserializationCallbackInterface backDelegationCallback;

    SharedSessionChunk(SharedSession session, int id) {
        this.session = session;
        this.id = id;
    }

    SharedSessionChunk(SharedSession session, String name, int id) {
        this.session = session;
        this.name = name;
        this.id = id;
    }

    public SharedSession getSession() {
        return this.session;
    }

    public String getName() throws SharedDataAccessException {
        if (this.name == null) {
            this.name = SharedSessionStore.impl.getChunkName(this.session.getHandle(), this.id);
        }
        return this.name;
    }

    public void setContent(Object content, SerializationCallback callback) throws SharedDataAccessException, OutOfSharedMemoryException, IOException {
        SerializationCallback callbackNonNull = callback == null ? defaultSerializationCallback : callback;
        SharedSessionStore.impl.setChunkContent(this.session.getHandle(), this.id, content, callbackNonNull, this);
    }

    public synchronized Object getContent(DeserializationCallback callback) throws SharedDataAccessException, IOException, ClassNotFoundException {
        DeserializationCallback callbackNonNull = callback == null ? defaultDeserializationCallback : callback;
        return SharedSessionStore.impl.getChunkContent(this.session.getHandle(), this.id, callbackNonNull, this);
    }

    public long getSize() throws SharedDataAccessException {
        return SharedSessionStore.impl.getChunkSize(this.session.getHandle(), this.id);
    }

    public void destroy() {
        SharedSessionStore.impl.destroyChunk(this.session.getHandle(), this.id);
    }

    public void setBackDelegationCallback(DeserializationCallbackInterface callback) {
        this.backDelegationCallback = callback;
    }

    Class<?> delegateResolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
        if (this.backDelegationCallback == null) {
            throw new NotActiveException("not in a call to readObject");
        }
        return this.backDelegationCallback.resolveClass(desc, null);
    }

    Class<?> delegateResolveProxyClass(String[] interfaces) throws IOException, ClassNotFoundException {
        if (this.backDelegationCallback == null) {
            throw new NotActiveException("not in a call to readObject");
        }
        return this.backDelegationCallback.resolveProxyClass(interfaces, null);
    }
}

