/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.session;

import com.sap.jvm.session.OutOfSharedMemoryException;
import com.sap.jvm.session.SharedDataAccessException;
import com.sap.jvm.session.SharedSession;
import com.sap.jvm.session.SharedSessionStore;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.Set;

public class SharedSessionDomain {
    private String name;
    private final int handle;

    SharedSessionDomain(int handle) {
        this.handle = handle;
    }

    SharedSessionDomain(String name, int handle) {
        this.name = name;
        this.handle = handle;
    }

    public String getName() throws SharedDataAccessException {
        if (this.name == null) {
            this.name = SharedSessionStore.impl.getDomainName(this.handle);
        }
        return this.name;
    }

    int getHandle() {
        return this.handle;
    }

    public void destroy() {
        SharedSessionStore.impl.destroyDomain(this.handle);
    }

    public SharedSession createSharedSession(String sessionName) throws SharedDataAccessException, OutOfSharedMemoryException {
        int sessionHandle = SharedSessionStore.impl.createSession(this.handle, sessionName);
        if (sessionHandle == -1) {
            return null;
        }
        return new SharedSession(this, sessionName, sessionHandle);
    }

    public SharedSession getSharedSession(String sessionName) throws SharedDataAccessException {
        int sessionHandle = SharedSessionStore.impl.getSession(this.handle, sessionName);
        if (sessionHandle == -1) {
            return null;
        }
        return new SharedSession(this, sessionName, sessionHandle);
    }

    public Set<SharedSession> sessions() throws SharedDataAccessException {
        final int[] handles = SharedSessionStore.impl.getSessionHandles(this.handle);
        return new AbstractSet<SharedSession>(){

            @Override
            public Iterator<SharedSession> iterator() {
                return new Iterator<SharedSession>(){
                    private int idx = 0;

                    @Override
                    public boolean hasNext() {
                        return this.idx < handles.length;
                    }

                    @Override
                    public SharedSession next() {
                        return new SharedSession(SharedSessionDomain.this, handles[this.idx++]);
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException("remove not supported");
                    }
                };
            }

            @Override
            public int size() {
                return handles.length;
            }
        };
    }
}

