/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.session;

import com.sap.jvm.session.OutOfSharedMemoryException;
import com.sap.jvm.session.SessionPermission;
import com.sap.jvm.session.SharedSessionDomain;
import com.sap.jvm.session.SharedSessionStoreImplInterface;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.ServiceLoader;
import java.util.Set;

public class SharedSessionStore {
    static final int INVALID_HANDLE = -1;
    public static final int INVALID_CHUNK_ID = -1;
    static final SharedSessionStoreImplInterface impl;
    private static final SharedSessionStore theInstance;

    public static SharedSessionStore getInstance() throws UnsupportedOperationException {
        SessionPermission.checkPermission(SessionPermission.SESSION_STORE_PERMISSION);
        if (theInstance == null) {
            throw new UnsupportedOperationException("Shared Session Store is not enabled");
        }
        return theInstance;
    }

    private static SharedSessionStore createSharedSessionStore() {
        if (impl == null) {
            return null;
        }
        return new SharedSessionStore();
    }

    private SharedSessionStore() {
    }

    public SharedSessionDomain createSharedSessionDomain(String name) throws OutOfSharedMemoryException {
        int domainHandle = impl.createDomain(name);
        if (domainHandle == -1) {
            return null;
        }
        return new SharedSessionDomain(name, domainHandle);
    }

    public SharedSessionDomain getSharedSessionDomain(String name) {
        int domainHandle = impl.getDomain(name);
        if (domainHandle == -1) {
            return null;
        }
        return new SharedSessionDomain(name, domainHandle);
    }

    public Set<SharedSessionDomain> sessionDomains() {
        final int[] handles = impl.getDomainHandles();
        return new AbstractSet<SharedSessionDomain>(){

            @Override
            public Iterator<SharedSessionDomain> iterator() {
                return new Iterator<SharedSessionDomain>(){
                    private int idx = 0;

                    @Override
                    public boolean hasNext() {
                        return this.idx < handles.length;
                    }

                    @Override
                    public SharedSessionDomain next() {
                        return new SharedSessionDomain(handles[this.idx++]);
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException("remove not supported");
                    }
                };
            }

            @Override
            public int size() {
                return handles.length;
            }
        };
    }

    public static int createDomain(String name) throws OutOfSharedMemoryException {
        return impl.createDomain(name);
    }

    public static int getDomain(String name) {
        return impl.getDomain(name);
    }

    public static int[] getDomainHandles() {
        return impl.getDomainHandles();
    }

    public static void destroyDomain(int domainHandle) {
        impl.destroyDomain(domainHandle);
    }

    static String displayName(String name) {
        if (name == null) {
            return "<unknown>";
        }
        return name;
    }

    static {
        ServiceLoader<SharedSessionStoreImplInterface> sl = ServiceLoader.load(SharedSessionStoreImplInterface.class);
        SharedSessionStoreImplInterface s = null;
        Iterator<SharedSessionStoreImplInterface> iterator = sl.iterator();
        if (iterator.hasNext()) {
            SharedSessionStoreImplInterface ssii;
            s = ssii = iterator.next();
        }
        impl = s;
        theInstance = SharedSessionStore.createSharedSessionStore();
    }
}

