/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.tracing;

import com.sap.jvm.APIServiceLoader;
import com.sap.jvm.tracing.TraceListener;
import com.sap.jvm.tracing.Tracer;
import com.sap.jvm.tracing.TracingServiceInterface;
import java.util.function.Supplier;
import java.util.regex.Pattern;

public final class Trace {
    private static final TracingServiceInterface theTracingService = APIServiceLoader.load(TracingServiceInterface.class).findFirst().orElse(null);
    private static final Tracer nullTracer;
    private static final Tracer genericTracer;

    public static Tracer get(Class<?> clazz) {
        return Trace.get(clazz.getName(), null);
    }

    public static Tracer get(String name) {
        return Trace.get(name, null);
    }

    public static Tracer get(Class<?> clazz, Object context) {
        return Trace.get(clazz.getName(), context);
    }

    public static Tracer get(String name, Object context) {
        return theTracingService == null ? nullTracer : theTracingService.get(name, context);
    }

    public static void setDefaultTraceLevel(Tracer.TraceLevel level) {
        if (theTracingService != null) {
            theTracingService.setDefaultTraceLevel(level);
        }
        genericTracer.setTraceLevel(level);
    }

    public static void setTraceLevel(Pattern pattern, Tracer.TraceLevel level) {
        if (theTracingService != null) {
            theTracingService.setTraceLevel(pattern, level);
        }
    }

    public static void setDefaultLocationType(Tracer.LocationType locationType) {
        if (theTracingService != null) {
            theTracingService.setDefaultLocationType(locationType);
        }
        genericTracer.setLocationType(locationType);
    }

    public static void setLocationType(Pattern pattern, Tracer.LocationType locationType) {
        if (theTracingService != null) {
            theTracingService.setLocationType(pattern, locationType);
        }
    }

    public static void enableStdErrOutput(boolean detailed) {
        if (theTracingService != null) {
            theTracingService.enableStdErrOutput(detailed);
        }
    }

    public static void disableStdErrOutput() {
        if (theTracingService != null) {
            theTracingService.disableStdErrOutput();
        }
    }

    public static boolean enableFileOutput(String filename, boolean detailed) {
        return theTracingService == null ? false : theTracingService.enableFileOutput(filename, detailed);
    }

    public static void disableFileOutput() {
        if (theTracingService != null) {
            theTracingService.disableFileOutput();
        }
    }

    public static void addListener(TraceListener listener) {
        if (theTracingService != null) {
            theTracingService.addListener(listener);
        }
    }

    public static boolean removeListener(TraceListener listener) {
        return theTracingService == null ? false : theTracingService.removeListener(listener);
    }

    public static void debug(String message) {
        genericTracer.debug(message);
    }

    public static void debug(Supplier<String> supplier) {
        genericTracer.debug(supplier);
    }

    public static void debug(String format, Object ... args) {
        genericTracer.debug(format, args);
    }

    public static void debug(Throwable throwable) {
        genericTracer.debug(throwable);
    }

    public static void debug(Throwable throwable, String message) {
        genericTracer.debug(throwable, message);
    }

    public static void debug(Throwable throwable, Supplier<String> supplier) {
        genericTracer.debug(throwable, supplier);
    }

    public static void debug(Throwable throwable, String format, Object ... args) {
        genericTracer.debug(throwable, format, args);
    }

    public static void info(String message) {
        genericTracer.info(message);
    }

    public static void info(Supplier<String> supplier) {
        genericTracer.info(supplier);
    }

    public static void info(String format, Object ... args) {
        genericTracer.info(format, args);
    }

    public static void info(Throwable throwable) {
        genericTracer.info(throwable);
    }

    public static void info(Throwable throwable, String message) {
        genericTracer.info(throwable, message);
    }

    public static void info(Throwable throwable, Supplier<String> supplier) {
        genericTracer.info(throwable, supplier);
    }

    public static void info(Throwable throwable, String format, Object ... args) {
        genericTracer.info(throwable, format, args);
    }

    public static void warn(String message) {
        genericTracer.warn(message);
    }

    public static void warn(Supplier<String> supplier) {
        genericTracer.warn(supplier);
    }

    public static void warn(String format, Object ... args) {
        genericTracer.warn(format, args);
    }

    public static void warn(Throwable throwable) {
        genericTracer.warn(throwable);
    }

    public static void warn(Throwable throwable, String message) {
        genericTracer.warn(throwable, message);
    }

    public static void warn(Throwable throwable, Supplier<String> supplier) {
        genericTracer.warn(throwable, supplier);
    }

    public static void warn(Throwable throwable, String format, Object ... args) {
        genericTracer.warn(throwable, format, args);
    }

    public static void error(String message) {
        genericTracer.error(message);
    }

    public static void error(Supplier<String> supplier) {
        genericTracer.error(supplier);
    }

    public static void error(String format, Object ... args) {
        genericTracer.error(format, args);
    }

    public static void error(Throwable throwable) {
        genericTracer.error(throwable);
    }

    public static void error(Throwable throwable, String message) {
        genericTracer.error(throwable, message);
    }

    public static void error(Throwable throwable, Supplier<String> supplier) {
        genericTracer.error(throwable, supplier);
    }

    public static void error(Throwable throwable, String format, Object ... args) {
        genericTracer.error(throwable, format, args);
    }

    static {
        if (theTracingService != null) {
            genericTracer = theTracingService.get("generic", null);
            nullTracer = null;
        } else {
            genericTracer = nullTracer = new Tracer(){

                @Override
                public Tracer.TraceLevel getTraceLevel() {
                    return Tracer.TraceLevel.NONE;
                }

                @Override
                public void setTraceLevel(Tracer.TraceLevel value) {
                }

                @Override
                public Tracer.LocationType getDebugLocationType() {
                    return null;
                }

                @Override
                public void setDebugLocationType(Tracer.LocationType type) {
                }

                @Override
                public Tracer.LocationType getInfoLocationType() {
                    return null;
                }

                @Override
                public void setInfoLocationType(Tracer.LocationType type) {
                }

                @Override
                public Tracer.LocationType getWarnLocationType() {
                    return null;
                }

                @Override
                public void setWarnLocationType(Tracer.LocationType type) {
                }

                @Override
                public Tracer.LocationType getErrorLocationType() {
                    return null;
                }

                @Override
                public void setErrorLocationType(Tracer.LocationType type) {
                }

                @Override
                public void setLocationType(Tracer.LocationType locationType) {
                }

                @Override
                public Object context() {
                    return null;
                }

                @Override
                public void debug(String message) {
                }

                @Override
                public void debug(Supplier<String> supplier) {
                }

                @Override
                public void debug(String format, Object ... args) {
                }

                @Override
                public void debug(Throwable throwable) {
                }

                @Override
                public void debug(Throwable throwable, String message) {
                }

                @Override
                public void debug(Throwable throwable, Supplier<String> supplier) {
                }

                @Override
                public void debug(Throwable throwable, String format, Object ... args) {
                }

                @Override
                public void info(String message) {
                }

                @Override
                public void info(Supplier<String> supplier) {
                }

                @Override
                public void info(String format, Object ... args) {
                }

                @Override
                public void info(Throwable throwable) {
                }

                @Override
                public void info(Throwable throwable, String message) {
                }

                @Override
                public void info(Throwable throwable, Supplier<String> supplier) {
                }

                @Override
                public void info(Throwable throwable, String format, Object ... args) {
                }

                @Override
                public void warn(String message) {
                }

                @Override
                public void warn(Supplier<String> supplier) {
                }

                @Override
                public void warn(String format, Object ... args) {
                }

                @Override
                public void warn(Throwable throwable) {
                }

                @Override
                public void warn(Throwable throwable, String message) {
                }

                @Override
                public void warn(Throwable throwable, Supplier<String> supplier) {
                }

                @Override
                public void warn(Throwable throwable, String format, Object ... args) {
                }

                @Override
                public void error(String message) {
                }

                @Override
                public void error(Supplier<String> supplier) {
                }

                @Override
                public void error(String format, Object ... args) {
                }

                @Override
                public void error(Throwable throwable) {
                }

                @Override
                public void error(Throwable throwable, String message) {
                }

                @Override
                public void error(Throwable throwable, Supplier<String> supplier) {
                }

                @Override
                public void error(Throwable throwable, String format, Object ... args) {
                }
            };
        }
    }
}

