/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.util.misc;

public class ByteConverter {
    public static boolean readBoolean(byte[] data, int offset) {
        return data[offset] != 0;
    }

    public static byte readInt8(byte[] data, int offset) {
        return data[offset];
    }

    public static short readUint8(byte[] data, int offset) {
        return (short)(data[offset] & 0xFF);
    }

    public static short readInt16(byte[] data, int offset) {
        int ch1 = data[offset] & 0xFF;
        int ch2 = data[offset + 1] & 0xFF;
        return (short)((ch1 << 8) + (ch2 << 0));
    }

    public static void writeInt16(byte[] data, int offset, short value) {
        data[offset] = (byte)(value >>> 8 & 0xFF);
        data[offset + 1] = (byte)(value & 0xFF);
    }

    public static char readUint16(byte[] data, int offset) {
        int ch1 = data[offset] & 0xFF;
        int ch2 = data[offset + 1] & 0xFF;
        return (char)((ch1 << 8) + (ch2 << 0));
    }

    public static void writeUint16(byte[] data, int offset, char value) {
        data[offset] = (byte)(value >> 8 & 0xFF);
        data[offset + 1] = (byte)(value & 0xFF);
    }

    public static int readInt32(byte[] data, int offset) {
        int ch1 = data[offset] & 0xFF;
        int ch2 = data[offset + 1] & 0xFF;
        int ch3 = data[offset + 2] & 0xFF;
        int ch4 = data[offset + 3] & 0xFF;
        return (ch1 << 24) + (ch2 << 16) + (ch3 << 8) + (ch4 << 0);
    }

    public static void writeInt32(byte[] data, int offset, int value) {
        data[offset] = (byte)(value >>> 24 & 0xFF);
        data[offset + 1] = (byte)(value >>> 16 & 0xFF);
        data[offset + 2] = (byte)(value >>> 8 & 0xFF);
        data[offset + 3] = (byte)(value & 0xFF);
    }

    public static long readUint32(byte[] data, int offset) {
        long ch1 = data[offset] & 0xFF;
        long ch2 = data[offset + 1] & 0xFF;
        long ch3 = data[offset + 2] & 0xFF;
        long ch4 = data[offset + 3] & 0xFF;
        return (ch1 << 24) + (ch2 << 16) + (ch3 << 8) + (ch4 << 0);
    }

    public static long readInt64(byte[] data, int offset) {
        return ((long)data[offset] << 56) + ((long)(data[offset + 1] & 0xFF) << 48) + ((long)(data[offset + 2] & 0xFF) << 40) + ((long)(data[offset + 3] & 0xFF) << 32) + ((long)(data[offset + 4] & 0xFF) << 24) + (long)((data[offset + 5] & 0xFF) << 16) + (long)((data[offset + 6] & 0xFF) << 8) + (long)((data[offset + 7] & 0xFF) << 0);
    }

    public static void writeInt64(byte[] data, int offset, long value) {
        data[offset] = (byte)(value >>> 56 & 0xFFL);
        data[offset + 1] = (byte)(value >>> 48 & 0xFFL);
        data[offset + 2] = (byte)(value >>> 40 & 0xFFL);
        data[offset + 3] = (byte)(value >>> 32 & 0xFFL);
        data[offset + 4] = (byte)(value >>> 24 & 0xFFL);
        data[offset + 5] = (byte)(value >>> 16 & 0xFFL);
        data[offset + 6] = (byte)(value >>> 8 & 0xFFL);
        data[offset + 7] = (byte)(value & 0xFFL);
    }

    public static float readFloat(byte[] data, int offset) {
        return Float.intBitsToFloat(ByteConverter.readInt32(data, offset));
    }

    public static double readDouble(byte[] data, int offset) {
        return Double.longBitsToDouble(ByteConverter.readInt64(data, offset));
    }

    public static void writeFloat(byte[] data, int offset, float value) {
        ByteConverter.writeInt32(data, offset, Float.floatToIntBits(value));
    }

    public static void writeDouble(byte[] data, int offset, double value) {
        ByteConverter.writeInt64(data, offset, Double.doubleToLongBits(value));
    }
}

