/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.util.misc;

import com.sap.jvm.util.misc.SocketAdapter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.Channels;
import java.nio.channels.Pipe;

public class PipedSocket {
    private Pipe pipe1;
    private Pipe pipe2;
    private final InputStream leftIS;
    private final InputStream rightIS;
    private final OutputStream leftOS;
    private final OutputStream rightOS;
    private SocketAdapter leftSide = new SocketAdapter(){

        @Override
        public InputStream getInputStream() throws IOException {
            return PipedSocket.this.leftIS;
        }

        @Override
        public OutputStream getOutputStream() throws IOException {
            return PipedSocket.this.leftOS;
        }

        @Override
        public void close() throws IOException {
            IOException e = null;
            try {
                PipedSocket.this.leftIS.close();
            }
            catch (IOException e1) {
                e = e1;
            }
            try {
                PipedSocket.this.leftOS.close();
            }
            catch (IOException e1) {
                if (e == null) {
                    e = e1;
                }
                e.addSuppressed(e1);
            }
            if (e != null) {
                throw e;
            }
        }
    };
    private SocketAdapter rightSide = new SocketAdapter(){

        @Override
        public InputStream getInputStream() throws IOException {
            return PipedSocket.this.rightIS;
        }

        @Override
        public OutputStream getOutputStream() throws IOException {
            return PipedSocket.this.rightOS;
        }

        @Override
        public void close() throws IOException {
            IOException e = null;
            try {
                PipedSocket.this.rightIS.close();
            }
            catch (IOException e1) {
                e = e1;
            }
            try {
                PipedSocket.this.rightOS.close();
            }
            catch (IOException e1) {
                if (e == null) {
                    e = e1;
                }
                e.addSuppressed(e1);
            }
            if (e != null) {
                throw e;
            }
        }
    };

    public SocketAdapter leftSide() {
        return this.leftSide;
    }

    public SocketAdapter rightSide() {
        return this.rightSide;
    }

    public void close() throws IOException {
        IOException e = null;
        try {
            this.leftSide.close();
        }
        catch (IOException e1) {
            e = e1;
        }
        try {
            this.rightSide.close();
        }
        catch (IOException e1) {
            if (e == null) {
                e = e1;
            }
            e.addSuppressed(e1);
        }
        if (e != null) {
            throw e;
        }
    }

    public PipedSocket() throws IOException {
        this.pipe1 = Pipe.open();
        this.leftIS = Channels.newInputStream(this.pipe1.source());
        this.rightOS = Channels.newOutputStream(this.pipe1.sink());
        this.pipe2 = Pipe.open();
        this.rightIS = Channels.newInputStream(this.pipe2.source());
        this.leftOS = Channels.newOutputStream(this.pipe2.sink());
    }
}

