/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.util.misc;

public class SignatureHelper {
    public static void main(String[] args) {
        SignatureHelper.toExternal("I");
        SignatureHelper.toExternal("[[Ljava/lang/String;");
        SignatureHelper.toExternal("(IZJB[[[I[[Ljava/lang/String;Z)");
        SignatureHelper.toExternal("(IZJB[[[I[[Ljava/lang/String;Z)V");
        SignatureHelper.toExternal("(IZJB[[[I[[Ljava/lang/String;Z)[[Ljava/lang/String;");
        SignatureHelper.toInternal("int");
        SignatureHelper.toInternal("Object");
        SignatureHelper.toInternal("java.lang.String");
        SignatureHelper.toInternal("(int, byte[][][], String[][])");
        SignatureHelper.toInternal("(int, byte[][][], String[][])void");
        SignatureHelper.toInternal("(int, byte[][][], String[][])String");
    }

    private static void toExternal(String str) {
        if (str.indexOf(40) == -1) {
            System.out.println(str + " => " + SignatureHelper.fromFieldDescriptor(str));
        } else {
            System.out.println(str + " => " + SignatureHelper.toExternalSignature(str));
        }
    }

    private static void toInternal(String str) {
        if (str.indexOf(40) == -1) {
            System.out.println(str + " => " + SignatureHelper.toFieldDescriptor(str));
        } else {
            System.out.println(str + " => " + SignatureHelper.toInternalSignature(str));
        }
    }

    public static String fromFieldDescriptor(String fieldDescriptor) {
        int arrayDim = 0;
        while (fieldDescriptor.charAt(arrayDim) == '[') {
            ++arrayDim;
        }
        String rest = fieldDescriptor.substring(arrayDim);
        StringBuffer result = new StringBuffer();
        switch (rest.charAt(0)) {
            case 'Z': {
                result.append("boolean");
                break;
            }
            case 'B': {
                result.append("byte");
                break;
            }
            case 'S': {
                result.append("short");
                break;
            }
            case 'C': {
                result.append("char");
                break;
            }
            case 'I': {
                result.append("int");
                break;
            }
            case 'J': {
                result.append("long");
                break;
            }
            case 'F': {
                result.append("float");
                break;
            }
            case 'D': {
                result.append("double");
                break;
            }
            case 'V': {
                result.append("void");
                break;
            }
            case 'L': {
                result.append(rest.substring(1, rest.length() - 1).replace('/', '.'));
            }
        }
        for (int i = 0; i < arrayDim; ++i) {
            result.append("[]");
        }
        return result.toString();
    }

    public static String toFieldDescriptor(String externalName) {
        String rest = externalName;
        StringBuffer result = new StringBuffer();
        while (rest.endsWith("[]")) {
            result.append("[");
            rest = rest.substring(0, rest.length() - 2);
        }
        if (rest.equals("void")) {
            result.append("V");
        } else if (rest.equals("boolean")) {
            result.append("Z");
        } else if (rest.equals("byte")) {
            result.append("B");
        } else if (rest.equals("short")) {
            result.append("S");
        } else if (rest.equals("char")) {
            result.append("C");
        } else if (rest.equals("int")) {
            result.append("I");
        } else if (rest.equals("long")) {
            result.append("J");
        } else if (rest.equals("float")) {
            result.append("F");
        } else if (rest.equals("double")) {
            result.append("D");
        } else {
            result.append('L');
            result.append(rest.replace('.', '/'));
            result.append(';');
        }
        return result.toString();
    }

    public static String toInternalSignature(String externalSignature) {
        String trimmed = externalSignature.trim();
        String[] params = trimmed.substring(1, trimmed.indexOf(41)).split(",");
        String returnType = trimmed.substring(trimmed.indexOf(41) + 1);
        StringBuffer result = new StringBuffer("(");
        for (int i = 0; i < params.length; ++i) {
            String param = params[i].trim();
            if (param.length() <= 0) continue;
            result.append(SignatureHelper.toFieldDescriptor(param));
        }
        result.append(")");
        if (returnType.length() > 0) {
            result.append(SignatureHelper.toFieldDescriptor(returnType.trim()));
        }
        return result.toString();
    }

    public static String toExternalSignature(String internalSignature) {
        StringBuffer result = new StringBuffer("(");
        String returnType = internalSignature.substring(internalSignature.indexOf(41) + 1);
        int endIndex = internalSignature.indexOf(41);
        int index = 1;
        while (index < endIndex) {
            int arrayDim = 0;
            while (internalSignature.charAt(arrayDim + index) == '[') {
                ++arrayDim;
            }
            switch (internalSignature.charAt(index += arrayDim)) {
                case 'Z': {
                    result.append("boolean");
                    break;
                }
                case 'B': {
                    result.append("byte");
                    break;
                }
                case 'S': {
                    result.append("short");
                    break;
                }
                case 'C': {
                    result.append("char");
                    break;
                }
                case 'I': {
                    result.append("int");
                    break;
                }
                case 'J': {
                    result.append("long");
                    break;
                }
                case 'F': {
                    result.append("float");
                    break;
                }
                case 'D': {
                    result.append("double");
                    break;
                }
                case 'V': {
                    result.append("void");
                    break;
                }
                case 'L': {
                    int end = internalSignature.indexOf(59, index);
                    result.append(internalSignature.substring(index + 1, end).replace('/', '.'));
                    index = end;
                    break;
                }
            }
            for (int i = 0; i < arrayDim; ++i) {
                result.append("[]");
            }
            if (++index >= endIndex) continue;
            result.append(", ");
        }
        result.append(")");
        if (returnType.length() > 0) {
            result.append(SignatureHelper.fromFieldDescriptor(returnType));
        }
        return result.toString();
    }
}

