/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.util.misc;

import com.sap.jvm.tracing.Trace;

public final class UTF8Util {
    private static final byte[] toLower;

    public static String asString(byte[] utf8String) {
        return UTF8Util.asString(utf8String, 0, utf8String.length);
    }

    public static String asString(byte[] utf8String, int offset, int length) {
        if (utf8String == null) {
            return null;
        }
        int sum = 0;
        StringBuilder result = new StringBuilder(length);
        for (int i = 0; i < length; ++i) {
            result.append((char)utf8String[i + offset]);
            sum = (char)(sum | (char)utf8String[i + offset]);
        }
        if ((sum & 0x7F) == sum) {
            return result.toString();
        }
        return UTF8Util.asStringNonAscii(utf8String, offset, length);
    }

    public static String asStringNonAscii(byte[] utf8String, int offset, int length) {
        if (utf8String == null) {
            return null;
        }
        int pos = offset;
        StringBuilder str = new StringBuilder(length);
        int count = 0;
        block5: while (count < length) {
            int c = utf8String[pos++] & 0xFF;
            switch (c >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    ++count;
                    str.append((char)c);
                    continue block5;
                }
                case 12: 
                case 13: {
                    byte char2;
                    if ((count += 2) > length) {
                        str.append('?');
                        --count;
                        continue block5;
                    }
                    if (((char2 = utf8String[pos++]) & 0xC0) != 128) {
                        str.append('?');
                        --count;
                        --pos;
                        continue block5;
                    }
                    str.append((char)((c & 0x1F) << 6 | char2 & 0x3F));
                    continue block5;
                }
                case 14: {
                    if ((count += 3) > length) {
                        str.append('?');
                        count -= 2;
                        continue block5;
                    }
                    byte char2 = utf8String[pos++];
                    byte char3 = utf8String[pos++];
                    if ((char2 & 0xC0) != 128 || (char3 & 0xC0) != 128) {
                        str.append('?');
                        count -= 2;
                        pos -= 2;
                        continue block5;
                    }
                    str.append((char)((c & 0xF) << 12 | (char2 & 0x3F) << 6 | (char3 & 0x3F) << 0));
                    continue block5;
                }
            }
            str.append('?');
            ++count;
        }
        return new String(str);
    }

    private static String traceInvalid(byte[] utf, StringBuilder str) {
        StringBuilder hex = new StringBuilder();
        for (int i = 0; i < utf.length; ++i) {
            String raw = "0" + Integer.toHexString(utf[i] & 0xFF);
            hex.append(raw.substring(raw.length() - 2));
            hex.append(' ');
        }
        Trace.warn("UTF-8 seems to be invalid.\nThe result so far is %s, input was (in hex) %s\n", str.toString(), hex);
        return str.toString();
    }

    public static byte[] modifiedUTF8(String str) {
        char c;
        int strlen = str.length();
        int utflen = 0;
        char[] charr = new char[strlen];
        int count = 0;
        str.getChars(0, strlen, charr, 0);
        for (int i = 0; i < strlen; ++i) {
            c = charr[i];
            if (c >= '\u0001' && c <= '\u007f') {
                ++utflen;
                continue;
            }
            if (c > '\u07ff') {
                utflen += 3;
                continue;
            }
            utflen += 2;
        }
        if (utflen > 65535) {
            utflen = 65535;
            Trace.warn(() -> "Could not convert string to UTF8 since it exceeeds 64byte: " + str);
            return UTF8Util.modifiedUTF8(str.substring(0, 16384) + " ... <truncated>");
        }
        byte[] bytearr = new byte[utflen];
        for (int i = 0; i < strlen; ++i) {
            c = charr[i];
            if (c >= '\u0001' && c <= '\u007f') {
                bytearr[count++] = (byte)c;
                continue;
            }
            if (c > '\u07ff') {
                bytearr[count++] = (byte)(0xE0 | c >> 12 & 0xF);
                bytearr[count++] = (byte)(0x80 | c >> 6 & 0x3F);
                bytearr[count++] = (byte)(0x80 | c >> 0 & 0x3F);
                continue;
            }
            bytearr[count++] = (byte)(0xC0 | c >> 6 & 0x1F);
            bytearr[count++] = (byte)(0x80 | c >> 0 & 0x3F);
        }
        return bytearr;
    }

    public static boolean isLower(byte[] string1, byte[] string2) {
        if (string1 == null || string1.length == 0) {
            return true;
        }
        if (string2 == null || string2.length == 0) {
            return false;
        }
        int len = Math.min(string1.length, string2.length);
        for (int i = 0; i < len; ++i) {
            int char1 = string1[i] & 0xFF;
            int char2 = string2[i] & 0xFF;
            if (char1 < char2) {
                return true;
            }
            if (char1 <= char2) continue;
            return false;
        }
        return string1.length < string2.length;
    }

    public static int compare(byte[] string1, byte[] string2) {
        int len = Math.min(string1.length, string2.length);
        for (int i = 0; i < len; ++i) {
            int char1 = string1[i] & 0xFF;
            int char2 = string2[i] & 0xFF;
            if (char1 < char2) {
                return -1;
            }
            if (char1 <= char2) continue;
            return 1;
        }
        if (string1.length < string2.length) {
            return -1;
        }
        if (string1.length > string2.length) {
            return 1;
        }
        return 0;
    }

    public static int compare(byte[] string1, int offset1, int length1, byte[] string2, int offset2, int length2) {
        int len = Math.min(length1, length2);
        for (int i = 0; i < len; ++i) {
            int char1 = string1[i + offset1] & 0xFF;
            int char2 = string2[i + offset2] & 0xFF;
            if (char1 < char2) {
                return -1;
            }
            if (char1 <= char2) continue;
            return 1;
        }
        if (length1 < length2) {
            return -1;
        }
        if (length1 > length2) {
            return 1;
        }
        return 0;
    }

    public static int compareIgnoreCase(byte[] string1, byte[] string2) {
        int len = Math.min(string1.length, string2.length);
        for (int i = 0; i < len; ++i) {
            byte char1 = string1[i];
            byte char2 = string2[i];
            if (char1 == char2) continue;
            if ((char1 | char2) < 0) {
                return UTF8Util.asStringNonAscii(string1, i, string1.length - i).compareToIgnoreCase(UTF8Util.asStringNonAscii(string2, i, string2.length - i));
            }
            if (toLower[char1] < toLower[char2]) {
                return -1;
            }
            if (toLower[char1] <= toLower[char2]) continue;
            return 1;
        }
        if (string1.length < string2.length) {
            return -1;
        }
        if (string1.length > string2.length) {
            return 1;
        }
        return 0;
    }

    public static int compareIgnoreCase(byte[] string1, int offset1, int length1, byte[] string2, int offset2, int length2) {
        int len = Math.min(length1, length2);
        for (int i = 0; i < len; ++i) {
            byte char1 = string1[i + offset1];
            byte char2 = string2[i + offset2];
            if (char1 == char2) continue;
            if ((char1 | char2) < 0) {
                return UTF8Util.asStringNonAscii(string1, offset1 + i, length1 - i).compareToIgnoreCase(UTF8Util.asStringNonAscii(string2, offset2 + i, length2 - i));
            }
            if (toLower[char1] < toLower[char2]) {
                return -1;
            }
            if (toLower[char1] <= toLower[char2]) continue;
            return 1;
        }
        if (length1 < length2) {
            return -1;
        }
        if (length1 > length2) {
            return 1;
        }
        return 0;
    }

    public static int compareForCaseInsenstiveOrder(byte[] string1, byte[] string2) {
        int result = UTF8Util.compareIgnoreCase(string1, string2);
        if (result == 0) {
            return UTF8Util.compare(string1, string2);
        }
        return result;
    }

    public static int compareForCaseInsenstiveOrder(byte[] string1, int offset1, int length1, byte[] string2, int offset2, int length2) {
        int result = UTF8Util.compareIgnoreCase(string1, offset1, length1, string2, offset2, length2);
        if (result == 0) {
            return UTF8Util.compare(string1, offset1, length1, string2, offset2, length2);
        }
        return result;
    }

    static {
        int i;
        toLower = new byte[128];
        for (i = 0; i < 128; ++i) {
            UTF8Util.toLower[i] = (byte)i;
        }
        for (i = 0; i < 26; ++i) {
            UTF8Util.toLower[i + 65] = (byte)(97 + i);
        }
    }
}

