/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.util.pair;

public final class IntPair
implements Comparable<IntPair> {
    private final int first;
    private final int second;

    public IntPair(int first, int second) {
        this.first = first;
        this.second = second;
    }

    public int getFirst() {
        return this.first;
    }

    public int getSecond() {
        return this.second;
    }

    public String toString() {
        return "<" + this.first + ", " + this.second + ">";
    }

    public boolean equals(Object other) {
        if (other instanceof IntPair) {
            IntPair otherPair = (IntPair)other;
            return this.first == otherPair.first && this.second == otherPair.second;
        }
        return false;
    }

    public int hashCode() {
        return this.first ^ 31 * this.second;
    }

    public int compareToByFirst(IntPair other) {
        if (this.first < other.first) {
            return -1;
        }
        if (this.first > other.first) {
            return 1;
        }
        return 0;
    }

    @Override
    public int compareTo(IntPair other) {
        return this.compareToByFirst(other);
    }
}

