/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.util.pair;

public final class LongPair
implements Comparable<LongPair> {
    private final long first;
    private final long second;

    public LongPair(long first, long second) {
        this.first = first;
        this.second = second;
    }

    public long getFirst() {
        return this.first;
    }

    public long getSecond() {
        return this.second;
    }

    public String toString() {
        return "<" + this.first + ", " + this.second + ">";
    }

    public boolean equals(Object other) {
        if (other instanceof LongPair) {
            LongPair otherPair = (LongPair)other;
            return this.first == otherPair.first && this.second == otherPair.second;
        }
        return false;
    }

    public int hashCode() {
        return (int)(this.first ^ this.first >>> 32 ^ 31L * (this.second ^ this.second >>> 32));
    }

    public int compareToByFirst(LongPair other) {
        if (this.first < other.first) {
            return -1;
        }
        if (this.first > other.first) {
            return 1;
        }
        return 0;
    }

    @Override
    public int compareTo(LongPair other) {
        return this.compareToByFirst(other);
    }
}

