/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.util.persistence;

import com.sap.jvm.util.misc.ByteConverter;
import com.sap.jvm.util.misc.UTF8Util;
import com.sap.jvm.util.persistence.TypedReader;
import com.sap.jvm.util.persistence.VersionMismatchException;
import java.io.EOFException;
import java.io.IOException;

public abstract class AbstractTypedReader
implements TypedReader {
    private static final long[] uint32ExpMapping = new long[]{0L, 1L, 2L, 3L, 4L, 5L, 6L, 7L, 8L, 9L, 10L, 11L, 12L, 14L, 15L, 16L, 17L, 19L, 20L, 22L, 24L, 26L, 28L, 31L, 33L, 36L, 39L, 42L, 46L, 50L, 54L, 59L, 64L, 69L, 75L, 81L, 88L, 95L, 103L, 112L, 121L, 131L, 142L, 154L, 167L, 181L, 196L, 212L, 230L, 249L, 270L, 292L, 317L, 343L, 372L, 403L, 437L, 473L, 512L, 555L, 601L, 651L, 706L, 765L, 828L, 897L, 972L, 1053L, 1141L, 1236L, 1339L, 1450L, 1571L, 1702L, 1844L, 1998L, 2164L, 2344L, 2540L, 2751L, 2980L, 3229L, 3498L, 3789L, 4105L, 4447L, 4817L, 5218L, 5653L, 6124L, 6634L, 7186L, 7785L, 8433L, 9136L, 9897L, 10721L, 11614L, 12581L, 13629L, 14764L, 15994L, 17326L, 18769L, 20332L, 22026L, 23860L, 25848L, 28001L, 30333L, 32859L, 35596L, 38561L, 41772L, 45251L, 49020L, 53103L, 57526L, 62317L, 67507L, 73130L, 79221L, 85819L, 92967L, 100709L, 109097L, 118184L, 128027L, 138690L, 150241L, 162754L, 176310L, 190994L, 206901L, 224134L, 242801L, 263023L, 284930L, 308661L, 334368L, 362217L, 392385L, 425066L, 460468L, 498819L, 540364L, 585370L, 634124L, 686938L, 744151L, 806129L, 873269L, 946002L, 1024791L, 1110143L, 1202604L, 1302765L, 1411269L, 1528809L, 1656139L, 1794074L, 1943497L, 2105366L, 2280716L, 2470670L, 2676445L, 2899358L, 3140837L, 3402428L, 3685806L, 3992786L, 4325334L, 4685578L, 5075826L, 5498577L, 5956538L, 6452640L, 6990062L, 7572243L, 8202913L, 8886110L, 9626208L, 10427947L, 11296460L, 12237309L, 13256519L, 14360615L, 15556669L, 16852338L, 18255920L, 19776402L, 21423521L, 23207823L, 25140735L, 27234633L, 29502925L, 31960138L, 34622004L, 37505569L, 40629298L, 44013193L, 47678923L, 51649961L, 55951734L, 60611790L, 65659969L, 71128595L, 77052687L, 83470179L, 90422166L, 97953163L, 106111395L, 114949102L, 124522876L, 134894021L, 146128948L, 158299600L, 171483909L, 185766301L, 201238232L, 217998774L, 236155253L, 255823931L, 277130757L, 300212165L, 325215956L, 352302239L, 381644459L, 413430507L, 447863922L, 485165195L, 525573181L, 569346631L, 616765842L, 668134460L, 723781420L, 784063053L, 849365365L, 920106516L, 996739490L, 1079754999L, 1169684627L, 1267104229L, 1372637625L, 1486960588L, 1610805175L, 1744964415L, 1890297384L, 2047734710L, 2218284530L, 2403038944L, 2603181011L, 2819992324L, 3054861215L, 3309291648L, 3584912846L};
    protected int size;
    protected byte[] data;
    protected int index;

    protected abstract void ensureBytes(int var1) throws EOFException;

    @Override
    public boolean hasNext() throws EOFException {
        if (this.index < this.size) {
            return true;
        }
        return this.hasNext(1);
    }

    @Override
    public boolean hasNext(int nrOfBytes) throws EOFException {
        assert (nrOfBytes <= 8);
        if (this.index + nrOfBytes <= this.size) {
            return true;
        }
        this.ensureBytes(nrOfBytes);
        return this.index + nrOfBytes <= this.size;
    }

    @Override
    public boolean readBoolean() throws EOFException {
        return this.readInt8() != 0;
    }

    @Override
    public boolean[] readBooleanArray() throws EOFException {
        int value = this.readInt8();
        boolean[] result = new boolean[8];
        for (int i = 0; i < result.length; ++i) {
            result[i] = (value & 1) != 0;
            value >>= 1;
        }
        return result;
    }

    @Override
    public byte peekInt8() throws EOFException {
        if (!this.hasNext()) {
            throw new EOFException("No further byte is available.");
        }
        return this.data[this.index];
    }

    @Override
    public byte readInt8() throws EOFException {
        byte result = this.peekInt8();
        ++this.index;
        return result;
    }

    @Override
    public short peekUint8() throws EOFException {
        if (!this.hasNext()) {
            throw new EOFException("No further byte is available.");
        }
        short result = (short)(this.data[this.index] + 256 & 0xFF);
        return result;
    }

    @Override
    public short readUint8() throws EOFException {
        short result = this.peekUint8();
        ++this.index;
        return result;
    }

    @Override
    public short peekInt16() throws EOFException {
        if (!this.hasNext(2)) {
            throw new EOFException("Only " + (this.data.length - this.index) + " bytes are available.");
        }
        return ByteConverter.readInt16(this.data, this.index);
    }

    @Override
    public short readInt16() throws EOFException {
        short result = this.peekInt16();
        this.index += 2;
        return result;
    }

    @Override
    public char peekUint16() throws EOFException {
        if (!this.hasNext(2)) {
            throw new EOFException("Only " + (this.data.length - this.index) + " bytes are available.");
        }
        return ByteConverter.readUint16(this.data, this.index);
    }

    @Override
    public char readUint16() throws EOFException {
        char result = this.peekUint16();
        this.index += 2;
        return result;
    }

    @Override
    public int peekInt32() throws EOFException {
        if (!this.hasNext(4)) {
            throw new EOFException("Only " + (this.size - this.index) + " bytes are available.");
        }
        return ByteConverter.readInt32(this.data, this.index);
    }

    @Override
    public int readInt32() throws EOFException {
        int result = this.peekInt32();
        this.index += 4;
        return result;
    }

    @Override
    public int readCompressedInt32() throws EOFException {
        int result = this.readUint16();
        if (result == 65535) {
            result = this.readInt32();
        }
        return result;
    }

    @Override
    public long readScaledInt32(long scale, boolean exact) throws EOFException {
        if (exact) {
            return this.readCompressedInt64();
        }
        return (long)this.readCompressedInt32() * scale;
    }

    @Override
    public long readExpCompressedUint32(boolean exact) throws EOFException {
        if (exact) {
            return this.readUint32();
        }
        short expIndex = this.readUint8();
        return uint32ExpMapping[expIndex];
    }

    @Override
    public long peekUint32() throws EOFException {
        if (!this.hasNext(4)) {
            throw new EOFException("Only " + (this.size - this.index) + " bytes are available.");
        }
        return ByteConverter.readUint32(this.data, this.index);
    }

    @Override
    public long readUint32() throws EOFException {
        long result = this.peekUint32();
        this.index += 4;
        return result;
    }

    @Override
    public long peekInt64() throws EOFException {
        if (!this.hasNext(8)) {
            throw new EOFException("Only " + (this.size - this.index) + " bytes are available.");
        }
        return ByteConverter.readInt64(this.data, this.index);
    }

    @Override
    public long readInt64() throws EOFException {
        long result = this.peekInt64();
        this.index += 8;
        return result;
    }

    @Override
    public long readCompressedInt64() throws EOFException {
        long result = this.readUint32();
        if (result == 0xFFFFFFFFL) {
            result = this.readInt64();
        }
        return result;
    }

    @Override
    public long readInt64Percentage(long maxValue, boolean exact) throws EOFException {
        if (exact) {
            return this.readInt64();
        }
        long maxUInt16 = 65535L;
        assert (maxValue >= 0L);
        long result = (long)this.readUint16() * maxValue / 65535L;
        return result;
    }

    @Override
    public long readInt64InvPercentage(long maxValue, boolean exact) throws EOFException {
        if (exact) {
            return this.readInt64();
        }
        long maxUInt16 = 65535L;
        assert (maxValue >= 0L);
        long result = (65535L - (long)this.readUint16()) * maxValue / 65535L;
        return result;
    }

    @Override
    public float readFloat() throws EOFException {
        return Float.intBitsToFloat(this.readInt32());
    }

    @Override
    public double readDouble() throws EOFException {
        return Double.longBitsToDouble(this.readInt64());
    }

    @Override
    public String readString() throws EOFException {
        char length = this.readUint16();
        byte[] utf = new byte[length];
        this.readBytes(utf);
        return UTF8Util.asString(utf);
    }

    @Override
    public String readBigString() throws EOFException {
        int length = this.readInt32();
        byte[] utf = new byte[length];
        this.readBytes(utf);
        return UTF8Util.asString(utf);
    }

    @Override
    public void readBytes(byte[] buffer) throws EOFException {
        this.readBytes(buffer, 0, buffer.length);
    }

    @Override
    public void readBytes(byte[] buffer, int offset, int len) throws EOFException {
        if (len == 0) {
            return;
        }
        int left = this.size - this.index;
        int toRead = len;
        int curr = offset;
        while (true) {
            if (left > 0) {
                int toCopy = Math.min(left, toRead);
                System.arraycopy(this.data, this.index, buffer, curr, toCopy);
                this.index += toCopy;
                curr += toCopy;
                if ((toRead -= toCopy) == 0) {
                    return;
                }
            }
            if (!this.hasNext(1)) {
                throw new EOFException("Tried to read " + len + " but only had " + toRead + " left");
            }
            left = this.size - this.index;
        }
    }

    @Override
    public byte[] readRemainingBytes() throws EOFException {
        Object chunks = null;
        int chunkIndex = 0;
        int left = this.size - this.index;
        byte[] chunk = new byte[left];
        while (true) {
            System.arraycopy(this.data, this.index, chunk, 0, left);
            this.index += left;
            if (!this.hasNext(1)) {
                int i;
                if (chunks == null) {
                    return chunk;
                }
                int len = 0;
                for (i = 0; i < ((byte[][])chunks).length && chunks[i] != null; ++i) {
                    assert ((len += chunks[i].length) >= 0);
                }
                chunk = new byte[len];
                len = 0;
                for (i = 0; i < ((byte[][])chunks).length && chunks[i] != null; ++i) {
                    System.arraycopy(chunks[i], 0, chunk, len, chunks[i].length);
                }
                return chunk;
            }
            if (chunks == null) {
                chunks = new byte[10][];
            }
            if (chunkIndex > ((byte[][])chunks).length) {
                byte[][] newChunks = new byte[((byte[][])chunks).length * 2][];
                System.arraycopy(chunks, 0, newChunks, 0, ((byte[][])chunks).length);
                chunks = newChunks;
            }
            chunks[chunkIndex] = chunk;
            ++chunkIndex;
            left = this.size - this.index;
            chunk = new byte[left];
        }
    }

    @Override
    public int readVersion(int minVersion, int maxVersion) throws IOException {
        int version = this.readInt32();
        if (version < minVersion || version > maxVersion) {
            throw new VersionMismatchException(version, minVersion, maxVersion);
        }
        return version;
    }

    @Override
    public int readVersion(int version) throws IOException {
        return this.readVersion(version, version);
    }
}

