/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.util.persistence;

import com.sap.jvm.util.misc.UTF8Util;
import com.sap.jvm.util.persistence.TypedWriter;
import java.io.IOException;
import java.io.UTFDataFormatException;

public abstract class AbstractTypedWriter
implements TypedWriter {
    private final byte[] data = new byte[8];

    protected AbstractTypedWriter() {
    }

    @Override
    public void writeBoolean(boolean value) throws IOException {
        this.writeInt8(value ? 1 : 0);
    }

    @Override
    public void writeInt32(int value) throws IOException {
        this.data[0] = (byte)(value >>> 24 & 0xFF);
        this.data[1] = (byte)(value >>> 16 & 0xFF);
        this.data[2] = (byte)(value >>> 8 & 0xFF);
        this.data[3] = (byte)(value >>> 0 & 0xFF);
        this.writeBytes(this.data, 0, 4);
    }

    @Override
    public void writeCompressedInt32(int value) throws IOException {
        if (value >= 0 && value <= Short.MAX_VALUE) {
            this.writeInt16((short)value);
        } else {
            this.writeUint16('\uffff');
            this.writeInt32(value);
        }
    }

    @Override
    public void writeVersion(int version) throws IOException {
        this.writeInt32(version);
    }

    @Override
    public void writeInt16(short value) throws IOException {
        this.data[0] = (byte)(value >>> 8 & 0xFF);
        this.data[1] = (byte)(value >>> 0 & 0xFF);
        this.writeBytes(this.data, 0, 2);
    }

    @Override
    public void writeUint16(char value) throws IOException {
        this.data[0] = (byte)(value >>> 8 & 0xFF);
        this.data[1] = (byte)(value >>> 0 & 0xFF);
        this.writeBytes(this.data, 0, 2);
    }

    @Override
    public void writeInt8(int value) throws IOException {
        this.data[0] = (byte)value;
        this.writeBytes(this.data, 0, 1);
    }

    @Override
    public void writeInt64(long value) throws IOException {
        this.data[0] = (byte)(value >>> 56);
        this.data[1] = (byte)(value >>> 48);
        this.data[2] = (byte)(value >>> 40);
        this.data[3] = (byte)(value >>> 32);
        this.data[4] = (byte)(value >>> 24);
        this.data[5] = (byte)(value >>> 16);
        this.data[6] = (byte)(value >>> 8);
        this.data[7] = (byte)(value >>> 0);
        this.writeBytes(this.data, 0, 8);
    }

    @Override
    public void writeFloat(float value) throws IOException {
        this.writeInt32(Float.floatToIntBits(value));
    }

    @Override
    public void writeDouble(double value) throws IOException {
        this.writeInt64(Double.doubleToLongBits(value));
    }

    @Override
    public void writeString(String value) throws IOException {
        byte[] utf = value == null ? new byte[]{} : UTF8Util.modifiedUTF8(value);
        int length = utf.length;
        if (length > 65535) {
            throw new UTFDataFormatException("encoded string too long: " + length + " bytes");
        }
        this.writeUint16((char)length);
        this.writeBytes(utf, 0, length);
    }

    @Override
    public void writeStringSafe(String value) throws IOException {
        if (value == null) {
            this.writeString("");
        } else {
            this.writeString(value);
        }
    }

    @Override
    public void writeBigString(String value) throws IOException {
        byte[] utf = value == null ? new byte[]{} : UTF8Util.modifiedUTF8(value);
        int length = utf.length;
        this.writeInt32((char)length);
        this.writeBytes(utf, 0, length);
    }

    @Override
    public void writeUTF(byte[] bytes, int offset, int length) throws IOException {
        char len = (char)length;
        if (len != length) {
            throw new UTFDataFormatException("UTF string too long: " + length + " bytes");
        }
        this.writeUint16(len);
        this.writeBytes(bytes, offset, length);
    }

    @Override
    public void writeUTF(byte[] bytes) throws IOException {
        char len = (char)bytes.length;
        if (len != bytes.length) {
            throw new UTFDataFormatException("UTF string too long: " + bytes.length + " bytes");
        }
        this.writeUint16(len);
        this.writeBytes(bytes, 0, len);
    }

    @Override
    public void writeBytes(byte[] bytes) throws IOException {
        this.writeBytes(bytes, 0, bytes.length);
    }
}

