/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.util.persistence;

import com.sap.jvm.tracing.Trace;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;

public final class ContinuedPacketReader {
    private static final int HEADER_SIZE = 4;
    private static final int OVERLAP_OVERHEAD = 4;
    private static final int CONTINUED_PACKET_BIT = 32768;
    private InputStream inputStream;
    private final byte[] buffer = new byte[4];
    private int nrOfValidBytes = 0;
    private byte[] data = new byte[4096];
    private final ArrayList<BinaryPacket> queuedPackets;
    final boolean handleInterleavedPackets;
    private BinaryPacket activePacket;

    public ContinuedPacketReader(InputStream inputStream, boolean handleInterleavePackets) {
        this.inputStream = inputStream;
        this.handleInterleavedPackets = handleInterleavePackets;
        this.queuedPackets = handleInterleavePackets ? new ArrayList() : null;
    }

    private int readHeader() throws IOException {
        while (this.nrOfValidBytes < 4) {
            int read = this.inputStream.read(this.buffer, this.nrOfValidBytes, 4 - this.nrOfValidBytes);
            if (read == -1) {
                return -1;
            }
            this.nrOfValidBytes += read;
        }
        return ((this.buffer[0] & 0xFF) << 8) + (this.buffer[1] & 0xFF);
    }

    private void consumeCurrentPacket() throws IOException {
        if (this.activePacket != null) {
            while (this.activePacket.isContinued()) {
                this.activePacket.nextData();
            }
            this.activePacket = null;
        }
    }

    public int readPacketType() throws IOException {
        this.consumeCurrentPacket();
        int type = this.readHeader();
        if (type == -1) {
            return type;
        }
        if (this.handleInterleavedPackets) {
            while ((type & 0x8000) == 32768) {
                this.queuePacket(this.readBinaryPacketImpl());
                type = this.readHeader();
            }
        }
        return type & 0xFFFF7FFF;
    }

    public void skipContinuedPackets() throws IOException {
        this.consumeCurrentPacket();
        int type = this.readHeader();
        if (type == -1) {
            return;
        }
        while ((type & 0x8000) == 32768) {
            this.readBinaryPacketImpl();
            type = this.readHeader();
        }
        this.readBinaryPacketImpl();
    }

    BinaryPacket getQueuedPacket(int type) {
        Iterator<BinaryPacket> it = this.queuedPackets.iterator();
        while (it.hasNext()) {
            BinaryPacket p = it.next();
            if (p.getType() != type) continue;
            it.remove();
            return p;
        }
        return null;
    }

    private void queuePacket(BinaryPacket toQueue) {
        assert (this.queuedPackets.size() == 0 || this.queuedPackets.get(this.queuedPackets.size() - 1).isContinued());
        toQueue.copyData();
        this.queuedPackets.add(toQueue);
    }

    BinaryPacket readBinaryPacketImpl() throws IOException {
        int toRead;
        int type = this.readHeader();
        int size = ((this.buffer[2] & 0xFF) << 8) + (this.buffer[3] & 0xFF);
        if (this.data.length < size + 8) {
            this.data = new byte[size + 8];
        }
        if ((toRead = size - 4) < 0) {
            throw new IOException("Found illegal packet size " + size);
        }
        int read = this.inputStream.read(this.data, 8, size);
        if (read >= toRead) {
            this.nrOfValidBytes = read - toRead;
            if (this.nrOfValidBytes > 0) {
                System.arraycopy(this.data, size + 4, this.buffer, 0, this.nrOfValidBytes);
            }
        } else if (read > 0) {
            this.nrOfValidBytes = 0;
            int off = 8 + read;
            toRead -= read;
            do {
                if ((read = this.inputStream.read(this.data, off, toRead)) == -1) {
                    throw new EOFException("End of file reached");
                }
                off += read;
            } while ((toRead -= read) > 0);
        } else {
            assert (read == -1);
            throw new EOFException("End of file reached");
        }
        return new BinaryPacket(type, size + 4, this.data);
    }

    public BinaryPacket readBinaryPacket() throws IOException, EOFException {
        this.consumeCurrentPacket();
        if (!this.handleInterleavedPackets) {
            BinaryPacket result = this.readBinaryPacketImpl();
            if (result.isContinued()) {
                this.activePacket = result;
            }
            return result;
        }
        while (true) {
            BinaryPacket result;
            if (!(result = this.readBinaryPacketImpl()).isContinued()) {
                this.activePacket = this.getQueuedPacket(result.getType());
                if (this.activePacket != null) {
                    this.queuePacket(result);
                    return this.activePacket;
                }
                return result;
            }
            this.queuePacket(result);
        }
    }

    public void close() {
        try {
            this.inputStream.close();
        }
        catch (IOException ex) {
            Trace.warn((Throwable)ex, "I/O Error during closing input stream.");
        }
    }

    public final class BinaryPacket {
        public static final int PACKET_OVERLAP = 8;
        private int type;
        byte[] packetData;
        private int size;
        private boolean isContinued;

        public BinaryPacket(int type, int size, byte[] data) {
            this.isContinued = (type & 0x8000) == 32768;
            this.type = type & 0xFFFF7FFF;
            this.packetData = data;
            this.size = size;
        }

        public int getType() {
            return this.type;
        }

        public int getSize() {
            return this.size;
        }

        public byte[] getData() {
            return this.packetData;
        }

        public boolean isContinued() {
            return this.isContinued;
        }

        void copyData() {
            this.packetData = (byte[])this.packetData.clone();
        }

        public byte[] nextData() throws EOFException {
            BinaryPacket next;
            assert (this.isContinued);
            if (ContinuedPacketReader.this.handleInterleavedPackets) {
                next = ContinuedPacketReader.this.getQueuedPacket(this.type);
                System.arraycopy(this.packetData, this.size - 8, next.packetData, 0, 8);
                this.packetData = next.packetData;
            } else {
                System.arraycopy(this.packetData, this.size - 8, this.packetData, 0, 8);
                try {
                    next = ContinuedPacketReader.this.readBinaryPacketImpl();
                }
                catch (IOException e) {
                    Trace.warn((Throwable)e, "Could not read packet");
                    EOFException e2 = new EOFException();
                    e2.initCause(e);
                    throw e2;
                }
                assert (next.getType() == this.type);
                assert (this.packetData == next.packetData);
            }
            this.size = next.size;
            this.isContinued = next.isContinued;
            return this.packetData;
        }
    }
}

