/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.util.persistence;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;

public final class FileHelper {
    public static void copy(File src, File dest) throws IOException {
        try (FileInputStream in = new FileInputStream(src);){
            FileHelper.copy((InputStream)in, dest);
        }
    }

    public static void copy(InputStream is, File file) throws IOException {
        try (FileOutputStream bos = new FileOutputStream(file);){
            FileHelper.copy(is, bos);
        }
    }

    public static void copy(InputStream is, OutputStream os) throws IOException {
        int read;
        byte[] buffer = new byte[8192];
        while ((read = is.read(buffer)) > 0) {
            os.write(buffer, 0, read);
        }
    }

    public static void delete(File file) throws IOException {
        if (!file.exists()) {
            return;
        }
        if (file.isDirectory()) {
            for (File child : file.listFiles()) {
                FileHelper.delete(child);
            }
        }
        if (!file.delete()) {
            throw new IOException("Cannot delete " + file);
        }
    }

    public static void unzip(File file, File dest) throws IOException {
        if (!dest.exists()) {
            if (!dest.mkdirs()) {
                throw new IOException("Could not create " + dest);
            }
        } else if (!dest.isDirectory()) {
            throw new IOException("Destination " + dest + " is not a directory");
        }
        try (ZipFile zip = new ZipFile(file);){
            for (ZipEntry zipEntry : Collections.list(zip.entries())) {
                File destFile = new File(dest + "/" + zipEntry.getName());
                if (zipEntry.isDirectory()) {
                    destFile.mkdirs();
                    continue;
                }
                BufferedInputStream is = new BufferedInputStream(zip.getInputStream(zipEntry));
                Throwable throwable = null;
                try {
                    FileHelper.copy((InputStream)is, destFile);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (is == null) continue;
                    if (throwable != null) {
                        try {
                            ((InputStream)is).close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    ((InputStream)is).close();
                }
            }
        }
    }

    public static void zip(File dir, File dest) throws IOException {
        if (!dir.exists()) {
            throw new IOException("Directory " + dir + " does not exists");
        }
        if (!dir.isDirectory()) {
            throw new IOException(dir + " is not a directory");
        }
        FileHelper.delete(dest);
        try (ZipOutputStream zos = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(dest)));){
            for (File file : dir.listFiles()) {
                FileHelper.zip(zos, "", file);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void zip(ZipOutputStream zos, String prefix, File file) throws IOException {
        String newPrefix = prefix + (prefix.length() == 0 ? "" : "/") + file.getName();
        if (file.isDirectory()) {
            for (File child : file.listFiles()) {
                FileHelper.zip(zos, newPrefix, child);
            }
        } else {
            try (BufferedInputStream bis = new BufferedInputStream(new FileInputStream(file));){
                zos.putNextEntry(new ZipEntry(newPrefix));
                FileHelper.copy((InputStream)bis, zos);
            }
            finally {
                zos.closeEntry();
            }
        }
    }

    public static void appendText(String text, File dest) throws IOException {
        try (BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(dest, true));
             ByteArrayInputStream bis = new ByteArrayInputStream(text.getBytes(StandardCharsets.UTF_8));){
            FileHelper.copy((InputStream)bis, bos);
        }
    }
}

