/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.util.persistence;

import com.sap.jvm.tracing.Trace;
import com.sap.jvm.util.threads.ThreadRunner;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.ArrayBlockingQueue;

public final class ParallelProfilingInputStream
extends InputStream {
    private final InputStreamImpl impl;

    public ParallelProfilingInputStream(InputStream inputStream) {
        this.impl = new InputStreamImpl(inputStream);
    }

    @Override
    public void close() throws IOException {
        this.impl.close();
    }

    @Override
    public int read() throws IOException {
        return this.impl.read();
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        return this.impl.read(b, off, len);
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.impl.close();
    }

    private static class Buffer {
        private final byte[] buffer;
        public int length;

        public Buffer(int length) {
            this.buffer = new byte[length];
            this.length = length;
        }

        public byte[] getBuffer() {
            return this.buffer;
        }

        public int getLength() {
            return this.length;
        }

        public void setLength(int length) {
            assert (length <= this.buffer.length);
            this.length = length;
        }
    }

    private static class InputStreamImpl
    extends InputStream
    implements Runnable {
        private static final int BUFFER_SIZE = 65536;
        private static final int NR_OF_BUFFERS = 3;
        private static final Buffer END_MARKER = new Buffer(0);
        private InputStream inputStream;
        private byte[] outputBuffer;
        private int outputOffset;
        private int outputLength;
        private Buffer activeBuffer;
        private final ArrayBlockingQueue<Buffer> outQueue;
        private final ArrayBlockingQueue<Buffer> inQueue;
        private volatile IOException exception;

        public InputStreamImpl(InputStream inputStream) {
            this.inputStream = inputStream;
            this.outQueue = new ArrayBlockingQueue(6);
            this.inQueue = new ArrayBlockingQueue(6);
            for (int i = 0; i < 3; ++i) {
                this.inQueue.add(new Buffer(65536));
            }
            ThreadRunner.run(this);
        }

        @Override
        public int read() throws IOException {
            assert (false);
            if (this.outputLength >= 1) {
                char result = (char)this.outputBuffer[this.outputOffset];
                ++this.outputOffset;
                --this.outputLength;
                return result;
            }
            byte[] tmp = new byte[1];
            if (this.read(tmp) != 1) {
                return -1;
            }
            return (char)tmp[0];
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            if (this.outputLength >= len) {
                System.arraycopy(this.outputBuffer, this.outputOffset, b, off, len);
                this.outputOffset += len;
                this.outputLength -= len;
                return len;
            }
            int currOffset = off;
            int currLength = len;
            while (true) {
                assert (this.outputLength >= 0);
                if (this.outputLength == 0) {
                    try {
                        if (this.activeBuffer == END_MARKER) {
                            if (this.exception != null) {
                                IOException e = new IOException("IO Error");
                                e.initCause(this.exception);
                                throw e;
                            }
                            if (len == currLength) {
                                return -1;
                            }
                            return len - currLength;
                        }
                        if (this.activeBuffer != null) {
                            this.activeBuffer.setLength(this.activeBuffer.getBuffer().length);
                            this.inQueue.add(this.activeBuffer);
                        }
                        this.activeBuffer = this.outQueue.take();
                        this.outputBuffer = this.activeBuffer.getBuffer();
                        this.outputOffset = 0;
                        this.outputLength = this.activeBuffer.getLength();
                    }
                    catch (InterruptedException e) {
                        IOException e2 = new IOException("Interrupted");
                        e2.initCause(e);
                        throw e2;
                    }
                }
                if (currLength <= this.outputLength) {
                    System.arraycopy(this.outputBuffer, this.outputOffset, b, currOffset, currLength);
                    this.outputLength -= currLength;
                    this.outputOffset += currLength;
                    return len;
                }
                System.arraycopy(this.outputBuffer, this.outputOffset, b, currOffset, this.outputLength);
                currLength -= this.outputLength;
                currOffset += this.outputLength;
                this.outputLength = 0;
            }
        }

        @Override
        public void close() throws IOException {
            if (this.inputStream != null) {
                this.inQueue.add(END_MARKER);
                while (this.activeBuffer != END_MARKER) {
                    try {
                        this.activeBuffer = this.outQueue.take();
                    }
                    catch (InterruptedException e) {
                        throw new IOException("Interrupted during close");
                    }
                }
                this.inputStream.close();
                this.inputStream = null;
            }
        }

        @Override
        public void run() {
            try {
                while (true) {
                    Buffer toFill;
                    if ((toFill = this.inQueue.take()) == END_MARKER) {
                        this.outQueue.add(END_MARKER);
                        return;
                    }
                    int len = this.inputStream.read(toFill.getBuffer());
                    if (len == -1) {
                        this.outQueue.add(END_MARKER);
                        return;
                    }
                    assert (len != 0);
                    toFill.setLength(len);
                    this.outQueue.add(toFill);
                }
            }
            catch (InterruptedException e) {
                this.exception = new IOException("Interrupted during operation");
                this.exception.initCause(e);
                this.outQueue.add(END_MARKER);
                return;
            }
            catch (IOException e) {
                this.exception = e;
                this.outQueue.add(END_MARKER);
                return;
            }
            catch (Throwable e) {
                Trace.error(e, "Error reading profiling file");
                this.exception = new IOException("Unexpected error occurred");
                this.exception.initCause(e);
                this.outQueue.add(END_MARKER);
                return;
            }
        }
    }
}

