/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.util.persistence;

import com.sap.jvm.util.persistence.AbstractTypedReader;
import com.sap.jvm.util.persistence.ContinuedPacketReader;
import com.sap.jvm.util.persistence.ProfilingInputStream;
import com.sap.jvm.util.persistence.TypedPacketWriter;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;

public class TypedPacketReader
extends AbstractTypedReader {
    protected ContinuedPacketReader packetReader;
    private ContinuedPacketReader.BinaryPacket packet;
    private int type;

    public TypedPacketReader(ContinuedPacketReader packetReader) {
        this.packetReader = packetReader;
    }

    private static int readUint16(InputStream is) throws IOException {
        int c1 = is.read();
        if (c1 < 0) {
            throw new EOFException();
        }
        int c2 = is.read();
        if (c2 < 0) {
            throw new EOFException();
        }
        return c1 * 256 + c2;
    }

    public static TypedPacketReader forProfilingConnection(InputStream is, TypedPacketWriter writer, boolean sendSystemInfo) throws IOException {
        writer.startPacket(36);
        writer.writeInt64(0L);
        writer.writeUint16('\u0001');
        writer.writeUint16('\u0006');
        writer.writeUint16('\u0000');
        writer.writeBoolean(sendSystemInfo);
        writer.finishPacket();
        int serverMajor = TypedPacketReader.readUint16(is);
        TypedPacketReader.readUint16(is);
        TypedPacketReader.readUint16(is);
        TypedPacketReader.readUint16(is);
        TypedPacketReader.readUint16(is);
        if (serverMajor != 1) {
            throw new IOException("Unsupported server major version " + serverMajor);
        }
        return new TypedPacketReader(new ContinuedPacketReader(new ProfilingInputStream(is), true));
    }

    int nextPacketType() throws IOException {
        return this.packetReader.readPacketType();
    }

    public void close() {
        this.packetReader.close();
    }

    public boolean nextNonFlushPacket() throws IOException {
        while (this.nextPacket()) {
            if (this.type == 501 || this.type == 1000) continue;
            return true;
        }
        return false;
    }

    public boolean nextPacket() throws IOException {
        try {
            ContinuedPacketReader.BinaryPacket nextPacket = this.packetReader.readBinaryPacket();
            if (nextPacket == null) {
                return false;
            }
            this.setNextPacketData(nextPacket);
            return true;
        }
        catch (EOFException e) {
            return false;
        }
    }

    public int getType() {
        return this.type;
    }

    @Override
    protected void ensureBytes(int nrOfBytes) throws EOFException {
        assert (nrOfBytes <= 8);
        if (this.packet == null) {
            return;
        }
        this.index -= this.size - 8;
        this.data = this.packet.nextData();
        this.size = this.packet.getSize();
        this.packet = this.packet.isContinued() ? this.packet : null;
    }

    private void setNextPacketData(ContinuedPacketReader.BinaryPacket binaryPacket) {
        this.type = binaryPacket.getType();
        this.size = binaryPacket.getSize();
        this.data = binaryPacket.getData();
        this.packet = binaryPacket.isContinued() ? binaryPacket : null;
        this.index = 8;
    }
}

