/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.util.persistence;

import com.sap.jvm.util.persistence.AbstractTypedWriter;
import java.io.IOException;
import java.io.OutputStream;

public class TypedPacketWriter
extends AbstractTypedWriter {
    private final OutputStream os;
    private final byte[] buffer;
    private int type;
    private int size;

    public TypedPacketWriter(OutputStream os) {
        this.os = os;
        this.type = -1;
        this.buffer = new byte[65536];
    }

    public void startPacket(int newType) throws IOException {
        if (newType < 0 || newType >= 32768) {
            throw new IOException("Invalid type " + newType);
        }
        if (this.type != -1) {
            throw new IOException("Already packet active with type " + this.type);
        }
        this.size = 4;
        this.type = newType;
    }

    public void finishAndFlushPacket() throws IOException {
        this.finishPacket();
        this.sendFlushPacket();
    }

    public void sendFlushPacket() throws IOException {
        this.startPacket(3);
        this.finishPacket();
    }

    public void finishPacket() throws IOException {
        if (this.type == -1) {
            throw new IOException("No active packet");
        }
        assert (this.size < 65536);
        assert (this.size >= 4);
        this.buffer[0] = (byte)(this.type >> 8 & 0xFF);
        this.buffer[1] = (byte)(this.type & 0xFF);
        this.buffer[2] = (byte)(this.size >> 8 & 0xFF);
        this.buffer[3] = (byte)(this.size & 0xFF);
        this.type = -1;
        this.os.write(this.buffer, 0, this.size);
        this.os.flush();
    }

    @Override
    public void writeBytes(byte[] bytes, int offset, int length) throws IOException {
        if (this.type < 0) {
            throw new IOException("No active packet");
        }
        if (this.size + length >= this.buffer.length) {
            int oldType = this.type;
            this.type |= 0x8000;
            this.finishPacket();
            this.startPacket(oldType);
        }
        if (this.size + length >= this.buffer.length) {
            throw new IOException("Content too large");
        }
        System.arraycopy(bytes, offset, this.buffer, this.size, length);
        this.size += length;
    }

    public void close() throws IOException {
        this.os.close();
    }
}

