/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.util.threads;

import com.sap.jvm.tracing.Trace;

public final class RunWaiter<T> {
    private Throwable throwable;
    private T result;
    private boolean finished;
    private Thread thread;
    private volatile boolean interrupted;

    public synchronized boolean waitOnFinish() {
        while (!this.finished) {
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                Trace.warn((Throwable)e, "Thread waiter was interrupted.");
                this.finish(e, null);
            }
        }
        return this.throwable == null;
    }

    public boolean success() {
        this.waitOnFinish();
        return this.throwable == null;
    }

    public boolean wasInterrupted() {
        return this.interrupted;
    }

    public Throwable getThrowable() {
        this.waitOnFinish();
        return this.throwable;
    }

    public T getResult() {
        this.waitOnFinish();
        return this.result;
    }

    public synchronized boolean interrupt() {
        this.interrupted = true;
        if (this.thread != null) {
            this.thread.interrupt();
            return true;
        }
        return false;
    }

    synchronized void finish(Throwable t, T r) {
        if (this.finished) {
            return;
        }
        this.throwable = t;
        this.result = r;
        this.finished = true;
        this.thread = null;
        this.notifyAll();
    }

    synchronized void setThread(Thread t) {
        this.thread = t;
    }
}

