/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.util.threads;

import com.sap.jvm.tracing.Trace;
import com.sap.jvm.util.threads.IntRunnable;
import com.sap.jvm.util.threads.RunWaiter;
import com.sap.jvm.util.threads.VoidRunnable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;

public final class ThreadRunner<T> {
    private static AtomicLong id = new AtomicLong();
    private static final ExecutorService executerService = new ThreadPoolExecutor(0, Integer.MAX_VALUE, 5L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), new ThreadFactory(){

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(r, "Profiling Thread " + id.addAndGet(1L));
            t.setDaemon(true);
            return t;
        }
    });

    public static RunWaiter<Void> run(final Runnable runnable) {
        return new ThreadRunner<Void>().run(new VoidRunnable<Void>(){

            @Override
            public Void run() throws Throwable {
                runnable.run();
                return null;
            }
        });
    }

    public static void runAndLog(final Runnable runnable) {
        new ThreadRunner<Void>().run(new VoidRunnable<Void>(){

            @Override
            public Void run() {
                try {
                    runnable.run();
                }
                catch (Throwable t) {
                    Trace.error(t, "Expception occured");
                }
                return null;
            }
        });
    }

    public RunWaiter<T> run(final VoidRunnable<T> runnable) {
        final RunWaiter waiter = new RunWaiter();
        executerService.submit(new Runnable(){

            @Override
            public void run() {
                try {
                    waiter.setThread(Thread.currentThread());
                    waiter.finish(null, waiter.wasInterrupted() ? null : (Object)runnable.run());
                }
                catch (Throwable t) {
                    waiter.finish(t, null);
                }
            }
        });
        return waiter;
    }

    public RunWaiter<T> run(final int param, final IntRunnable<T> runnable) {
        final RunWaiter waiter = new RunWaiter();
        executerService.submit(new Runnable(){

            @Override
            public void run() {
                try {
                    waiter.setThread(Thread.currentThread());
                    waiter.finish(null, waiter.wasInterrupted() ? null : (Object)runnable.run(param));
                }
                catch (Throwable t) {
                    waiter.finish(t, null);
                }
            }
        });
        return waiter;
    }
}

