/*
 * Decompiled with CFR 0.152.
 */
package com.sap.vmc.core;

import com.sap.vmc.core.SystemInfo;
import com.sap.vmc.util.collection.Node;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

@Deprecated
public class FactoryBase {
    private static final String PKG_BASE = "com.sap.vmc.core.impl";
    private static final String PKG_DW = "com.sap.vmc.core.impl.dw";
    private static final String PKG_DWJ = "com.sap.vmc.core.impl.dwj";
    private static final String PKG_LITE = "com.sap.vmc.core.impl.lite";
    private static final String PKG_VMCONTAINER = "com.sap.vmc.core.impl.vmcontainer";
    private static final String PKG_CVM = "com.sap.vmc.core.impl.cvm";
    private static final String PKG_SAPJVM = "com.sap.vmc.core.impl.sapjvm";
    private static final String PKG_GENERIC = "com.sap.vmc.core.impl.generic";
    private static final String PKG_PART_ADMIN = "admin";
    private static final String PKG_PART_INTERNAL = "internal";
    protected static final String PKG_API = "com.sap.vmc.core";
    protected static PrintStream out = System.err;
    private static final Node[] LOOKUP_TABLE = new Node[7];
    protected static String[] searchOrder = null;
    protected static Map<Class<?>, Class<?>> implClassCache = new HashMap();
    protected static int type = SystemInfo.getEngineType();
    protected static int vmType = SystemInfo.getVMType();

    protected static void reInitialize() {
        Node generic = new Node(PKG_GENERIC);
        Node cvm = new Node(PKG_CVM);
        Node sapjvm = new Node(PKG_SAPJVM);
        Node vmcontainer = new Node(PKG_VMCONTAINER);
        Node lite = new Node(PKG_LITE);
        Node dwj = new Node(PKG_DWJ);
        Node dw = new Node(PKG_DW);
        switch (vmType) {
            case 5: {
                generic.addChild(vmcontainer);
                break;
            }
            case 0: {
                generic.addChild(cvm);
                cvm.addChild(vmcontainer);
                break;
            }
            case 6: {
                generic.addChild(sapjvm);
                sapjvm.addChild(vmcontainer);
                break;
            }
            default: {
                throw new InternalError("cannot happen");
            }
        }
        vmcontainer.addChild(lite);
        vmcontainer.addChild(dwj);
        dwj.addChild(dw);
        FactoryBase.LOOKUP_TABLE[2] = dwj;
        FactoryBase.LOOKUP_TABLE[1] = dw;
        FactoryBase.LOOKUP_TABLE[3] = lite;
        FactoryBase.LOOKUP_TABLE[4] = vmcontainer;
        FactoryBase.LOOKUP_TABLE[0] = cvm;
        FactoryBase.LOOKUP_TABLE[5] = generic;
        FactoryBase.LOOKUP_TABLE[6] = sapjvm;
    }

    protected static void setPrintStream(PrintStream psout) {
        if (psout == null) {
            throw new NullPointerException("psout");
        }
        out = psout;
    }

    protected static String[] getSearchOrder() {
        if (searchOrder == null) {
            Node start = LOOKUP_TABLE[type];
            ArrayList<String> list = new ArrayList<String>();
            do {
                list.add(start.getName());
            } while ((start = start.getParent()) != null);
            searchOrder = list.toArray(new String[list.size()]);
        }
        return searchOrder;
    }

    protected static String getImplementationName(String interfName) {
        if (interfName == null) {
            throw new NullPointerException("interfName");
        }
        return interfName + "Impl";
    }

    protected static String getBaseName(String interfName) {
        if (!interfName.startsWith("com.sap.vmc.core.")) {
            return null;
        }
        return interfName.substring(PKG_API.length() + 1);
    }

    protected static String getSemiFlatBaseName(String interfName) {
        String baseName = FactoryBase.getBaseName(interfName);
        if (baseName == null) {
            return null;
        }
        if (baseName.startsWith(PKG_PART_ADMIN) || baseName.startsWith(PKG_PART_INTERNAL)) {
            int lastDot;
            int firstDot = baseName.indexOf(46);
            if (firstDot != (lastDot = baseName.lastIndexOf(46))) {
                baseName = baseName.substring(0, firstDot) + baseName.substring(lastDot);
            }
        } else {
            int lastDot = baseName.lastIndexOf(46);
            if (lastDot > -1) {
                baseName = baseName.substring(lastDot + 1);
            }
        }
        return baseName;
    }

    protected static String getFlatName(String interfName) {
        if (!interfName.startsWith("com.sap.vmc.core.")) {
            return null;
        }
        int lastDot = interfName.lastIndexOf(46);
        return interfName.substring(lastDot + 1);
    }

    private static Class<?> findImplementation(String[] searchOrder, String implName) {
        Class<?> implClass = null;
        for (int i = 0; i < searchOrder.length; ++i) {
            String className = searchOrder[i] + "." + implName;
            try {
                implClass = Class.forName(className);
                break;
            }
            catch (ClassNotFoundException classNotFoundException) {
                continue;
            }
        }
        return implClass;
    }

    protected static Class<?> findImplementationClass(Class<?> interf) throws ClassNotFoundException {
        Class<?> implClass = implClassCache.get(interf);
        if (implClass == null) {
            FactoryBase.getSearchOrder();
            String ifName = FactoryBase.getBaseName(interf.getName());
            String implName = FactoryBase.getImplementationName(ifName);
            implClass = FactoryBase.findImplementation(searchOrder, implName);
            if (implClass == null) {
                ifName = FactoryBase.getSemiFlatBaseName(interf.getName());
                implName = FactoryBase.getImplementationName(ifName);
                implClass = FactoryBase.findImplementation(searchOrder, implName);
            }
            if (implClass == null) {
                ifName = FactoryBase.getFlatName(interf.getName());
                implName = FactoryBase.getImplementationName(ifName);
                implClass = FactoryBase.findImplementation(searchOrder, implName);
            }
        }
        if (implClass == null) {
            throw new ClassNotFoundException();
        }
        implClassCache.put(interf, implClass);
        return implClass;
    }

    public static final Object createImplementation(Class<?> interf) throws ClassNotFoundException {
        Class<?> implClass = null;
        try {
            implClass = FactoryBase.findImplementationClass(interf);
            if (!interf.isAssignableFrom(implClass)) {
                throw new ClassCastException();
            }
            Object instance = implClass.newInstance();
            return instance;
        }
        catch (InstantiationException ex) {
            out.println("InstantiationException during creation of implementation for interface '" + interf.getName() + "'. Name of implementation class is '" + implClass.getName() + "'. Exception message: " + ex.getMessage());
        }
        catch (ClassCastException ex) {
            out.println("Found implementation does not implement the interface '" + interf.getName() + "'. Name of implementation class is '" + implClass.getName() + "'.");
        }
        catch (IllegalAccessException ex) {
            out.println("IllegalAccessException during creation of implementation for interface '" + interf.getName() + "'. Name of implementation class is '" + implClass.getName() + "'. Exception message: " + ex.getMessage());
        }
        catch (ClassNotFoundException ex) {
            out.println("Implementation class for interface '" + interf.getName() + "' could not be found. . Exception message: " + ex.getMessage());
            throw ex;
        }
        return null;
    }

    static {
        FactoryBase.reInitialize();
    }
}

