/*
 * Decompiled with CFR 0.152.
 */
package com.sap.vmc.core;

import com.sap.vmc.core.Tracer;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

@Deprecated
public abstract class TracerFactory {
    private static final String GENERIC_IMPLEMENTATION = "com.sap.vmc.core.impl.generic.trace.TracerFactory$TracerFactoryDelegateImpl";
    private static final String CVM_IMPLEMENTATION = "com.sap.vmc.core.impl.cvm.trace.TracerFactory$TracerFactoryDelegateImpl";
    private static final String CONTAINER_IMPLEMENTATION = "com.sap.vmc.core.impl.vmcontainer.trace.TracerFactory$TracerFactoryDelegateImpl";
    protected static final String TRACE_LEVEL_PROPERTY = "JKERNEL_TRACE_LEVEL";
    protected static TracerFactoryDelegate delegate;

    protected static void setTracerFactory(TracerFactoryDelegate factory) {
        delegate = factory;
    }

    public static Tracer getTracer(String component) {
        return delegate.getTracer(component);
    }

    public static Tracer getTracer(Class<?> component) {
        return delegate.getTracer(component.getName());
    }

    static {
        String implementation = GENERIC_IMPLEMENTATION;
        try {
            String clazzName = "com.sap.vmc.core.impl.cvm.natives.InfoNatives";
            String methodName = "getVmContainerType0";
            Class[] argTypes = new Class[]{};
            Object[] args = new Object[]{};
            Class<?> clazz = Class.forName(clazzName);
            Method method = clazz.getMethod(methodName, argTypes);
            Object result = method.invoke(null, args);
            int type = (Integer)result;
            implementation = type == 1 || type == 2 ? CONTAINER_IMPLEMENTATION : CVM_IMPLEMENTATION;
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | UnsatisfiedLinkError | InvocationTargetException clazzName) {
            // empty catch block
        }
        try {
            Class<?> implClass = Class.forName(implementation);
            delegate = (TracerFactoryDelegate)implClass.newInstance();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @Deprecated
    protected static abstract class AbstractTracer
    implements Tracer {
        private static final DateFormat dateFormat;
        protected static final String CATCHING = "Catching:";
        protected static final String THROWING = "Throwing:";
        protected String component;

        protected AbstractTracer() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static String formatDate(Date date) {
            DateFormat dateFormat = AbstractTracer.dateFormat;
            synchronized (dateFormat) {
                return AbstractTracer.dateFormat.format(date);
            }
        }

        @Override
        public void error(String message, Throwable throwable) {
            this.trace(1, message, throwable);
        }

        @Override
        public void error(String message) {
            this.trace(1, message);
        }

        @Override
        public void trace(int level, String message, Throwable throwable) {
            if (message == null) {
                throw new NullPointerException("The parameter \"message\" is null");
            }
            if (throwable == null) {
                throw new NullPointerException("The parameter \"throwable\" is null");
            }
            String trace = this.getTrace(level, message, throwable);
            if (trace != null) {
                this.print(trace);
            }
        }

        @Override
        public void trace(int level, String message) {
            if (message == null) {
                throw new NullPointerException("The parameter \"message\" is null");
            }
            String trace = this.getTrace(level, message, null);
            if (trace != null) {
                this.print(trace);
            }
        }

        @Override
        public void trace(String message, Throwable throwable) {
            this.trace(2, message, throwable);
        }

        @Override
        public void trace(String message) {
            this.trace(2, message);
        }

        @Override
        public void catching(Throwable throwable) {
            this.trace(2, CATCHING, throwable);
        }

        @Override
        public void throwing(Throwable throwable) {
            this.trace(2, THROWING, throwable);
        }

        @Override
        public boolean isErrorLogged() {
            return this.getTraceLevel() >= 1;
        }

        @Override
        public boolean isExtensiveLogged() {
            return this.getTraceLevel() >= 3;
        }

        @Override
        public boolean isNormalLogged() {
            return this.getTraceLevel() >= 2;
        }

        protected String getTrace(int level, String message, Throwable throwable) {
            if (level <= 0 || this.getTraceLevel() < level) {
                return null;
            }
            String timestamp = AbstractTracer.formatDate(new Date());
            String levelStr = null;
            switch (level) {
                case 1: {
                    levelStr = "\tError";
                    break;
                }
                case 2: {
                    levelStr = "\tWarning";
                    break;
                }
                case 3: {
                    levelStr = "\tDebug";
                }
            }
            StringBuffer line = new StringBuffer();
            line.append(timestamp).append(levelStr);
            line.append("\t").append(this.component);
            line.append("\t").append(message);
            if (throwable != null) {
                line.append("\t--> ");
                StringWriter stringWriter = new StringWriter();
                throwable.printStackTrace(new PrintWriter(stringWriter));
                line.append(stringWriter.toString());
            }
            return line.toString();
        }

        protected abstract int getTraceLevel();

        protected abstract void print(String var1);

        static {
            String timezoneOffset;
            Calendar cal = Calendar.getInstance();
            int offset = cal.get(15);
            if (offset == 0) {
                timezoneOffset = "Z";
            } else {
                DecimalFormat nf = new DecimalFormat("00");
                int offsetMinutes = offset / 60000;
                int hours = Math.abs(offsetMinutes / 60);
                int minutes = Math.abs(offsetMinutes % 60);
                timezoneOffset = (offset < 0 ? "-" : "+") + nf.format(hours) + ":" + nf.format(minutes);
            }
            dateFormat = new SimpleDateFormat("yyyy-MM-dd' 'HH:mm:ss'" + timezoneOffset + "'");
        }
    }

    @Deprecated
    protected static interface TracerFactoryDelegate {
        public Tracer getTracer(String var1);
    }
}

