/*
 * Decompiled with CFR 0.152.
 */
package com.sap.vmc.core.impl.common.monitor.stacktrace;

import com.sap.vmc.core.impl.common.monitor.stacktrace.AddressValueImpl;
import com.sap.vmc.core.impl.common.monitor.stacktrace.Resolvable;
import com.sap.vmc.core.impl.common.monitor.stacktrace.ResolveHelper;
import com.sap.vmc.core.monitor.stacktrace.ExtendedStackTraceElement;
import com.sap.vmc.core.monitor.stacktrace.ObjectReference;
import com.sap.vmc.core.monitor.stacktrace.ObjectType;
import com.sap.vmc.core.monitor.stacktrace.Type;
import com.sap.vmc.core.monitor.stacktrace.Value;
import java.util.Map;

@Deprecated
public final class ExtendedStackTraceElementImpl
implements ExtendedStackTraceElement,
Resolvable {
    private final String className;
    private Object classType;
    private Value classLoader;
    private final String methodName;
    private final String methodSignature;
    private final String fileName;
    private final int lineNumber;
    private final boolean isNative;
    private final boolean isCompiled;
    private final int pcOffset;
    private final boolean isStatic;
    private final int nrOfDeclaredParameters;
    private final String[] names;
    private final Value[] values;
    private Object[] associatedTypes;

    public ExtendedStackTraceElementImpl(String className, long classBlockAddress, long classLoaderAddress, String methodName, String methodSignature, boolean isNative, boolean isCompiled, int lineNumber, String fileName, int pcOffset, boolean isStatic, int nrOfDeclaredParameters, String[] names, Value[] values, long[] associatedTypes) {
        if (className == null) {
            throw new IllegalArgumentException("className is null");
        }
        if (methodName == null) {
            throw new NullPointerException("methodName is null");
        }
        if (methodSignature == null) {
            throw new NullPointerException("methodSignature is null");
        }
        if (lineNumber < -1) {
            throw new IllegalArgumentException("lineNumber is " + lineNumber);
        }
        if (pcOffset < -1) {
            throw new IllegalArgumentException("pcOffset is " + pcOffset);
        }
        if (nrOfDeclaredParameters < 0 || nrOfDeclaredParameters > 255) {
            throw new IllegalArgumentException("nrOfDeclaredParameters is " + nrOfDeclaredParameters);
        }
        if (names == null) {
            throw new NullPointerException("names is null");
        }
        if (values == null) {
            throw new NullPointerException("values is null");
        }
        if (names.length != values.length) {
            throw new IllegalArgumentException("names and values are not of the same size");
        }
        if (associatedTypes == null) {
            throw new NullPointerException("associatedTypes is null");
        }
        this.className = className;
        if (classBlockAddress == 0L) {
            throw new IllegalArgumentException("ClassBlockAddress cannot be 0");
        }
        this.classType = new AddressValueImpl(classBlockAddress);
        this.classLoader = classLoaderAddress == 0L ? null : new AddressValueImpl(classLoaderAddress);
        this.methodName = methodName;
        this.methodSignature = methodSignature;
        this.isNative = isNative;
        this.isCompiled = isCompiled;
        this.lineNumber = lineNumber;
        this.fileName = fileName;
        this.pcOffset = pcOffset;
        this.isStatic = isStatic;
        this.nrOfDeclaredParameters = nrOfDeclaredParameters;
        this.names = (String[])names.clone();
        this.values = (Value[])values.clone();
        this.associatedTypes = new Object[associatedTypes.length];
        for (int i = 0; i < associatedTypes.length; ++i) {
            this.associatedTypes[i] = new Long(associatedTypes[i]);
        }
    }

    @Override
    public String getClassName() {
        return this.className;
    }

    @Override
    public ObjectType getType() {
        return (ObjectType)this.classType;
    }

    @Override
    public Value getClassLoader() {
        return this.classLoader;
    }

    @Override
    public String getMethodName() {
        return this.methodName;
    }

    @Override
    public String getMethodSignature() {
        return this.methodSignature;
    }

    @Override
    public String getFileName() {
        return this.fileName;
    }

    @Override
    public int getLineNumber() {
        return this.lineNumber;
    }

    @Override
    public int getPcOffset() {
        return this.pcOffset;
    }

    @Override
    public boolean isNative() {
        return this.isNative;
    }

    @Override
    public boolean isCompiled() {
        return this.isCompiled;
    }

    @Override
    public boolean isStatic() {
        return this.isStatic;
    }

    @Override
    public int getNrOfParameters() {
        return this.nrOfDeclaredParameters + (this.isStatic ? 0 : 1);
    }

    @Override
    public int getNrOfLocals() {
        return this.names.length;
    }

    @Override
    public String getName(int index) {
        return this.names[index];
    }

    @Override
    public Value getValue(int index) {
        return this.values[index];
    }

    @Override
    public int getNrOfAssociatedTypes() {
        return this.associatedTypes.length;
    }

    @Override
    public ObjectType getAssociatedType(int index) {
        return (ObjectType)this.associatedTypes[index];
    }

    @Override
    public void resolve(Map resolverMap) {
        Long key;
        Object resolved;
        if (this.classType instanceof AddressValueImpl && (resolved = resolverMap.get(key = new Long(((AddressValueImpl)this.classType).getAddress()))) instanceof ObjectType) {
            this.classType = resolved;
        }
        if (this.classLoader instanceof AddressValueImpl && (resolved = resolverMap.get(key = new Long(((AddressValueImpl)this.classLoader).getAddress()))) instanceof ObjectReference) {
            this.classLoader = (ObjectReference)resolved;
        }
        ResolveHelper.resolve(resolverMap, this.values);
        int nrOfAssociatedTypes = this.associatedTypes.length;
        for (int i = 0; i < nrOfAssociatedTypes; ++i) {
            Object resolved2;
            if (!(this.associatedTypes[i] instanceof Long) || !((resolved2 = resolverMap.get(this.associatedTypes[i])) instanceof Type)) continue;
            this.associatedTypes[i] = resolved2;
        }
    }
}

