/*
 * Decompiled with CFR 0.152.
 */
package com.sap.vmc.core.impl.sapjvm.monitor.vm;

import com.sap.vmc.core.monitor.vm.MonitorInfo;
import com.sap.vmc.core.monitor.vm.VmInfo;
import java.io.DataInputStream;
import java.io.IOException;

@Deprecated
public class MonitorInfoImpl
implements MonitorInfo {
    private final String monitorName;
    private final long address;
    private final int owner;
    private final int[] lockingThreads;
    private final int[] waitingThreads;

    public static MonitorInfoImpl[] readMonitorInfos(DataInputStream stream) throws IOException {
        int nrOfMonitors = stream.readInt();
        MonitorInfoImpl[] result = new MonitorInfoImpl[nrOfMonitors];
        for (int i = 0; i < nrOfMonitors; ++i) {
            result[i] = new MonitorInfoImpl(stream);
        }
        return result;
    }

    MonitorInfoImpl(DataInputStream stream) throws IOException {
        this.monitorName = stream.readUTF();
        this.address = stream.readLong();
        this.owner = (int)stream.readLong();
        int nrOfLockingThreads = stream.readInt();
        this.lockingThreads = new int[nrOfLockingThreads];
        for (int i = 0; i < nrOfLockingThreads; ++i) {
            this.lockingThreads[i] = (int)stream.readLong();
        }
        int nrOfWaitingThreads = stream.readInt();
        this.waitingThreads = new int[nrOfWaitingThreads];
        for (int i = 0; i < nrOfWaitingThreads; ++i) {
            this.waitingThreads[i] = (int)stream.readLong();
        }
    }

    @Override
    public String getMonitorName() {
        return this.monitorName;
    }

    @Override
    public long getAddress() {
        return this.address;
    }

    @Override
    public int getOwner() {
        return this.owner;
    }

    @Override
    public String getOwnerAsString() {
        if (this.owner == -1) {
            return null;
        }
        return VmInfo.getThreadStateInfo(this.owner).getThreadName();
    }

    @Override
    public int[] getWaitingThreads() {
        return (int[])this.waitingThreads.clone();
    }

    @Override
    public String[] getWaitingThreadsAsString() {
        return MonitorInfoImpl.getIdsAsStrings(this.waitingThreads);
    }

    @Override
    public int[] getLockingThreads() {
        return (int[])this.lockingThreads.clone();
    }

    @Override
    public String[] getLockingThreadsAsString() {
        return MonitorInfoImpl.getIdsAsStrings(this.lockingThreads);
    }

    private static String[] getIdsAsStrings(int[] ids) {
        String[] result = new String[ids.length];
        for (int i = 0; i < ids.length; ++i) {
            result[i] = VmInfo.getThreadStateInfo(ids[i]).getThreadName();
        }
        return result;
    }
}

