/*
 * Decompiled with CFR 0.152.
 */
package com.sap.vmc.core.monitor;

import com.sap.vmc.core.FactoryBase;
import com.sap.vmc.core.Tracer;
import com.sap.vmc.core.TracerFactory;
import java.io.Serializable;

@Deprecated
public class ClassLoaderIdentifier
implements Serializable,
Comparable<ClassLoaderIdentifier> {
    private static final long serialVersionUID = -4700012964293088683L;
    public static final String BOOTSTRAP_CLASSLOADER_NAME = "<bootstrap>";
    public static final long BOOTSTRAP_CLASSLOADER_ADDRESS = 0L;
    private static ClassLoaderIdentifierDelegate delegate = Factory.getInstance();
    private long address;
    private String name;

    protected ClassLoaderIdentifier() {
    }

    public ClassLoaderIdentifier(ClassLoader classLoader) {
        if (classLoader != null) {
            this.name = classLoader.getClass().getName();
            this.address = delegate.getAddress(classLoader);
        } else {
            this.name = BOOTSTRAP_CLASSLOADER_NAME;
            this.address = 0L;
        }
    }

    public ClassLoaderIdentifier(long address, String name) {
        if (name == null) {
            throw new NullPointerException("name is null");
        }
        if (address == 0L && !name.equals(BOOTSTRAP_CLASSLOADER_NAME)) {
            throw new IllegalArgumentException("Address \"0\" only allowed for the bootstrap class loader(parameter name=\"" + name + "\")");
        }
        if (name.equals(BOOTSTRAP_CLASSLOADER_NAME) && address != 0L) {
            throw new IllegalArgumentException("Address for the bootstrap class loader must be 0(parameter address=\"" + address + "\")");
        }
        this.address = address;
        this.name = name;
    }

    public long getAddress() {
        return this.address;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public int compareTo(ClassLoaderIdentifier o) {
        if (this.address == o.getAddress()) {
            return 0;
        }
        if (this.address > o.getAddress()) {
            return 1;
        }
        return -1;
    }

    public boolean equals(Object obj) {
        if (!obj.getClass().equals(this.getClass())) {
            return false;
        }
        ClassLoaderIdentifier tmpIdentifier = (ClassLoaderIdentifier)obj;
        return tmpIdentifier.getAddress() == this.getAddress() && tmpIdentifier.getName().equals(this.getName());
    }

    public int hashCode() {
        int addressHash = (int)(this.getAddress() & 0xFFFFFFFFFFFFFFFFL) ^ (int)(this.getAddress() >> 32);
        return addressHash ^ this.getName().hashCode();
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("ClassLoaderIdentifier [address=\"");
        buffer.append(this.address);
        buffer.append("\", name=\"");
        buffer.append(this.name);
        buffer.append("\"]");
        return buffer.toString();
    }

    @Deprecated
    static class Factory
    extends FactoryBase {
        Factory() {
        }

        static ClassLoaderIdentifierDelegate getInstance() {
            try {
                return (ClassLoaderIdentifierDelegate)Factory.createImplementation(ClassLoaderIdentifierDelegate.class);
            }
            catch (ClassNotFoundException e) {
                Tracer tracer = TracerFactory.getTracer(ClassLoaderIdentifier.class);
                tracer.trace("Cannot find an implementation class for the \"ClassLoaderIdentifierDelegate\" interface", e);
                return null;
            }
        }
    }

    @Deprecated
    protected static interface ClassLoaderIdentifierDelegate {
        public long getAddress(ClassLoader var1);
    }
}

