/*
 * Decompiled with CFR 0.152.
 */
package com.sap.vmc.core.monitor.trace;

import com.sap.vmc.core.FactoryBase;
import com.sap.vmc.core.Tracer;
import com.sap.vmc.core.TracerFactory;
import com.sap.vmc.core.monitor.ClassIdentifier;
import com.sap.vmc.core.monitor.trace.AgeRange;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

@Deprecated
public class VmMemoryTrace {
    private static VmMemoryTraceDelegate delegate = Factory.getInstance();

    public static boolean enableClassStatisticTrace(String fileName, boolean explicitGcTrigger) {
        if (fileName == null) {
            throw new NullPointerException("The parameter \"fileName\" is null");
        }
        int[] startAgeRanges = null;
        int[] endAgeRanges = null;
        startAgeRanges = new int[]{0};
        endAgeRanges = new int[]{Integer.MAX_VALUE};
        return delegate.enableClassStatisticTrace(fileName, startAgeRanges, endAgeRanges, explicitGcTrigger);
    }

    public static boolean enableClassStatisticTrace(String fileName, Collection<AgeRange> ranges, boolean explicitGcTrigger) {
        if (ranges == null) {
            throw new NullPointerException("The parameter \"ranges\" is null");
        }
        if (ranges.size() == 0) {
            return VmMemoryTrace.enableClassStatisticTrace(fileName, explicitGcTrigger);
        }
        if (fileName == null) {
            throw new NullPointerException("The parameter \"fileName\" is null");
        }
        int[] startAgeRanges = null;
        int[] endAgeRanges = null;
        startAgeRanges = new int[ranges.size()];
        endAgeRanges = new int[ranges.size()];
        Iterator<AgeRange> it = ranges.iterator();
        int index = 0;
        while (it.hasNext()) {
            AgeRange range = it.next();
            startAgeRanges[index] = range.getLowerLimit();
            endAgeRanges[index] = range.getUpperLimit();
            ++index;
        }
        return delegate.enableClassStatisticTrace(fileName, startAgeRanges, endAgeRanges, explicitGcTrigger);
    }

    public static boolean enableClassStatisticTrace(String fileName, AgeRange range, boolean explicitGcTrigger) {
        if (range == null) {
            throw new NullPointerException("The parameter \"range\" is null");
        }
        ArrayList<AgeRange> tmpCollection = new ArrayList<AgeRange>();
        tmpCollection.add(range);
        return VmMemoryTrace.enableClassStatisticTrace(fileName, tmpCollection, explicitGcTrigger);
    }

    public static boolean dumpClassStatistics() {
        return delegate.dumpClassStatistics();
    }

    public static boolean disableClassStatisticTrace() {
        return delegate.disableClassStatisticTrace();
    }

    public static boolean enableReferenceTrace(String fileName, boolean explicitGcTrigger) {
        return VmMemoryTrace.enableReferenceTrace(fileName, new ArrayList<ClassIdentifier>(), explicitGcTrigger, false, -1);
    }

    public static boolean enableReferenceTrace(String fileName, boolean explicitGcTrigger, boolean withObjectIdOnly) {
        return VmMemoryTrace.enableReferenceTrace(fileName, new ArrayList<ClassIdentifier>(), explicitGcTrigger, withObjectIdOnly, -1);
    }

    public static boolean enableReferenceTrace(String fileName, ClassIdentifier classIdentifier, boolean explicitGcTrigger) {
        return VmMemoryTrace.enableReferenceTrace(fileName, classIdentifier, explicitGcTrigger, false, -1);
    }

    public static boolean enableReferenceTrace(String fileName, ClassIdentifier classIdentifier, boolean explicitGcTrigger, boolean withObjectIdOnly) {
        return VmMemoryTrace.enableReferenceTrace(fileName, classIdentifier, explicitGcTrigger, withObjectIdOnly, -1);
    }

    public static boolean enableReferenceTrace(String fileName, ClassIdentifier classIdentifier, boolean explicitGcTrigger, int survivedGcs) {
        if (classIdentifier == null) {
            throw new NullPointerException("The parameter \"classIdentifier\" is null");
        }
        ArrayList<ClassIdentifier> classIdentifierCollection = new ArrayList<ClassIdentifier>();
        classIdentifierCollection.add(classIdentifier);
        return VmMemoryTrace.enableReferenceTrace(fileName, classIdentifierCollection, explicitGcTrigger, survivedGcs);
    }

    public static boolean enableReferenceTrace(String fileName, ClassIdentifier classIdentifier, boolean explicitGcTrigger, boolean withObjectIdOnly, int survivedGcs) {
        if (classIdentifier == null) {
            throw new NullPointerException("The parameter \"classIdentifier\" is null");
        }
        ArrayList<ClassIdentifier> classIdentifierCollection = new ArrayList<ClassIdentifier>();
        classIdentifierCollection.add(classIdentifier);
        return VmMemoryTrace.enableReferenceTrace(fileName, classIdentifierCollection, explicitGcTrigger, withObjectIdOnly, survivedGcs);
    }

    public static boolean enableReferenceTrace(String fileName, Collection<ClassIdentifier> classIdentifiers, boolean explicitGcTrigger) {
        return VmMemoryTrace.enableReferenceTrace(fileName, classIdentifiers, explicitGcTrigger, -1);
    }

    public static boolean enableReferenceTrace(String fileName, Collection<ClassIdentifier> classIdentifiers, boolean explicitGcTrigger, boolean withObjectIdOnly) {
        return VmMemoryTrace.enableReferenceTrace(fileName, classIdentifiers, explicitGcTrigger, withObjectIdOnly, -1);
    }

    public static boolean enableReferenceTrace(String fileName, Collection<ClassIdentifier> classIdentifiers, boolean explicitGcTrigger, int survivedGcs) {
        return VmMemoryTrace.enableReferenceTrace(fileName, classIdentifiers, explicitGcTrigger, false, survivedGcs);
    }

    public static boolean enableReferenceTrace(String fileName, Collection<ClassIdentifier> classIdentifiers, boolean explicitGcTrigger, boolean withObjectIdOnly, int survivedGcs) {
        if (fileName == null) {
            throw new NullPointerException("The parameter \"fileName\" is null");
        }
        if (classIdentifiers == null) {
            throw new NullPointerException("The parameter \"classIdentifiers\" is null");
        }
        long[] classLoaderAddress = null;
        String[] classLoaderName = null;
        String[] className = null;
        if (classIdentifiers.size() == 0) {
            classLoaderAddress = new long[]{};
            classLoaderName = new String[]{};
            className = new String[]{};
        } else {
            classLoaderAddress = new long[classIdentifiers.size()];
            classLoaderName = new String[classIdentifiers.size()];
            className = new String[classIdentifiers.size()];
            int index = 0;
            for (ClassIdentifier classIdentifier : classIdentifiers) {
                classLoaderAddress[index] = classIdentifier.getClassLoaderIdentifier().getAddress();
                classLoaderName[index] = classIdentifier.getClassLoaderIdentifier().getName().replace('.', '/');
                className[index] = classIdentifier.getName().replace('.', '/');
                ++index;
            }
        }
        return delegate.enableReferenceTrace(fileName, classLoaderAddress, classLoaderName, className, explicitGcTrigger, withObjectIdOnly, survivedGcs);
    }

    public static boolean dumpReferences() {
        return delegate.dumpReferences();
    }

    public static boolean disableReferenceTrace() {
        return delegate.disableReferenceTrace();
    }

    public static boolean enableAllocationTrace(String fileName) {
        return VmMemoryTrace.enableAllocationTrace(fileName, new ArrayList<ClassIdentifier>(), -1);
    }

    public static boolean enableAllocationTrace(String fileName, ClassIdentifier classIdentifier) {
        return VmMemoryTrace.enableAllocationTrace(fileName, classIdentifier, -1);
    }

    public static boolean enableAllocationTrace(String fileName, Collection<ClassIdentifier> classIdentifiers) {
        return VmMemoryTrace.enableAllocationTrace(fileName, classIdentifiers, -1);
    }

    public static boolean enableAllocationTrace(String fileName, ClassIdentifier classIdentifier, int stackFrames) {
        if (classIdentifier == null) {
            throw new NullPointerException("The parameter \"classIdentifier\" is null");
        }
        ArrayList<ClassIdentifier> classIdentifierCollection = new ArrayList<ClassIdentifier>();
        classIdentifierCollection.add(classIdentifier);
        return VmMemoryTrace.enableAllocationTrace(fileName, classIdentifierCollection, stackFrames);
    }

    public static boolean enableAllocationTrace(String fileName, Collection<ClassIdentifier> classIdentifiers, int stackFrames) {
        if (fileName == null) {
            throw new NullPointerException("The parameter \"fileName\" is null");
        }
        if (classIdentifiers == null) {
            throw new NullPointerException("The parameter \"classIdentifiers\" is null");
        }
        long[] classLoaderAddress = null;
        String[] classLoaderName = null;
        String[] className = null;
        if (classIdentifiers.size() == 0) {
            classLoaderAddress = new long[]{};
            classLoaderName = new String[]{};
            className = new String[]{};
        } else {
            classLoaderAddress = new long[classIdentifiers.size()];
            classLoaderName = new String[classIdentifiers.size()];
            className = new String[classIdentifiers.size()];
            int index = 0;
            for (ClassIdentifier classIdentifier : classIdentifiers) {
                classLoaderAddress[index] = classIdentifier.getClassLoaderIdentifier().getAddress();
                classLoaderName[index] = classIdentifier.getClassLoaderIdentifier().getName().replace('.', '/');
                className[index] = classIdentifier.getName().replace('.', '/');
                ++index;
            }
        }
        return delegate.enableAllocationTrace(fileName, classLoaderAddress, classLoaderName, className, stackFrames);
    }

    public static boolean disableAllocationTrace() {
        return delegate.disableAllocationTrace();
    }

    @Deprecated
    static class Factory
    extends FactoryBase {
        Factory() {
        }

        static VmMemoryTraceDelegate getInstance() {
            try {
                return (VmMemoryTraceDelegate)Factory.createImplementation(VmMemoryTraceDelegate.class);
            }
            catch (ClassNotFoundException e) {
                Tracer tracer = TracerFactory.getTracer(VmMemoryTrace.class);
                tracer.error("Cannot find implementation for \"VmMemoryTraceDelegate\".");
                return null;
            }
        }
    }

    protected static interface VmMemoryTraceDelegate {
        public boolean enableClassStatisticTrace(String var1, int[] var2, int[] var3, boolean var4);

        public boolean dumpClassStatistics();

        public boolean disableClassStatisticTrace();

        public boolean enableReferenceTrace(String var1, long[] var2, String[] var3, String[] var4, boolean var5, boolean var6, int var7);

        public boolean dumpReferences();

        public boolean disableReferenceTrace();

        public boolean enableAllocationTrace(String var1, long[] var2, String[] var3, String[] var4, int var5);

        public boolean disableAllocationTrace();
    }
}

