/*
 * Decompiled with CFR 0.152.
 */
package com.sap.vmc.core.monitor.vm;

import com.sap.jvm.monitor.vm.VmTraceFlag;
import java.lang.reflect.Field;
import java.util.ArrayList;

@Deprecated
public class VmTraceFlagsSet {
    public static final int TRACE_METHODS = 1;
    public static final int TRACE_EXCEPTIONS = 14;
    public static final int TRACE_CLASSLOADING = 18;
    public static final int TRACE_CLASSLOADING_STACKS = 19;
    public static final int TRACE_CLASSUNLOADING = 23;
    public static final int TRACE_CONTROLS = 32;
    public static final int TRACE_CONTROLS_INTERNALS = 33;
    public static final int TRACE_DEBUG_ON_DEMAND = 34;
    public static final int TRACE_DEBUG_MODIFICATIONS = 35;
    public static final int TRACE_FILE_IO = 39;
    public static final int TRACE_FILE_IO_READ_WRITE = 40;
    public static final int TRACE_FILE_IO_READ_WRITE_DATA = 41;
    public static final int TRACE_NET = 43;
    public static final int TRACE_NET_SEND_RECV = 44;
    public static final int TRACE_NET_SEND_RECV_DATA = 45;
    public static final int TRACE_NET_HOST_NAME_LOOKUP = 46;
    public static final int TRACE_NET_REVERSE_HOST_NAME_LOOKUP = 47;
    public static final int TRACE_NET_REVERSE_HOST_NAME_LOOKUP_TIME = 48;
    public static final int TRACE_JDWP = 49;
    public static final int TRACE_JDWP_INTERNALS = 50;
    public static final int TRACE_CLASS_STATISTICS = 56;
    public static final int TRACE_CMS_PLAB_REFILL_SAMPLING = 58;
    public static final int TRACE_CMS_FREE_LIST_SPACE_CENSUS = 59;
    public static final int TRACE_CONC_MARK_SWEEP_GC = 60;
    public static final int TRACE_CONC_MARK_SWEEP_GC_INTERNALS = 61;
    public static final int TRACE_GARBAGE_FIRST_GC = 62;
    public static final int TRACE_GARBAGE_FIRST_GC_INTERNALS = 63;
    public static final int TRACE_PROFILING = 64;
    public static final int TRACE_PROFILING_INTERNALS = 65;
    public static final int TRACE_MPT_BASICS = 70;
    public static final int TRACE_MPT_VALUES = 71;
    public static final int TRACE_MPT_INTERNALS = 72;
    public static final int TRACE_MPT_MODIFIERS = 73;
    public static final int TRACE_SYNC_BASICS = 74;
    public static final int TRACE_IO_BASICS = 75;
    public static final int TRACE_NETIO_BASICS = 76;
    public static final int TRACE_CHUNKED_PROFILING_FILE = 80;
    public static final int TRACE_VMC_ALLOCATION_LOCAL_MISC = 129;
    public static final int TRACE_VMC_ALLOCATION_SHARED_DATA = 132;
    public static final int TRACE_VMC_ALLOCATION_SHARED_MISC = 134;
    public static final int TRACE_VMC_ALLOCATION_SHARED_BOOTSTRAP = 135;
    public static final int TRACE_VMC_ALLOCATION_ANY = 150;
    public static final int TRACE_GC_ONE_LINE_EXPERIMENTAL = 151;
    public static final int TRACE_GC_STATISTICS_LEVEL_1 = 152;
    public static final int TRACE_GC_STATISTICS_LEVEL_2 = 153;
    public static final int TRACE_GC_STATISTICS_LEVEL_3 = 154;
    public static final int TRACE_GC_STATISTICS_LEVEL_4 = 155;
    public static final int TRACE_GC_STATISTICS_LEVEL_5 = 156;
    public static final int TRACE_EXCEPTIONS_WITH_BYTE_CODE = 157;
    public static final int TRACE_METHODS_WITH_PARAMETERS = 158;
    public static final int TRACE_EXTENDED_STACK_TRACE = 159;
    public static final int TRACE_DETAILED_CLASS_STATISTICS = 160;
    public static final int TRACE_GC_STATISTICS_LEVEL_6 = 161;
    public static final int TRACE_HEAP_MANAGER = 162;
    public static final int TRACE_HEAP_MANAGER_INTERNALS = 163;
    public static final int TRACE_OS_MISC = 164;
    public static final int TRACE_OS_MMAP = 165;
    public static final int TRACE_OS_SIGNALS = 166;
    public static final int TRACE_PROFILING_STACK_TRACE = 167;
    public static final int TRACE_PROFILING_STACK_TRACE_INTERNALS = 168;
    public static final int TRACE_BYTE_CODE_UTILS = 169;
    public static final int TRACE_BYTE_CODE_UTILS_INTERNALS = 170;
    public static final int TRACE_PROFILING_TIME_BASED_SAMPLING = 171;
    public static final int TRACE_PROFILING_TIME_BASED_SAMPLING_INTERNALS = 172;
    public static final int TRACE_VM_INIT = 174;
    public static final int TRACE_SHARED_SYNCHRONIZATION = 175;
    public static final int TRACE_OS_DLL_LOAD = 176;
    public static final int TRACE_JAVA_ZIP_OPEN_CLOSE = 177;
    public static final int TRACE_JAVA_ZIP_GET_ENTRY = 178;
    public static final int TRACE_JVMTI = 179;
    public static final int TRACE_JDK_INTERNALS = 180;
    public static final int TRACE_MONITORING_INTERNAL = 182;
    public static final int TRACE_HEARTBEAT = 183;
    public static final int TRACE_RAINY_DAY_FUND = 184;
    public static final int TRACE_JVMTI_STACK_TRACE_RETRIEVAL = 185;
    public static final int TRACE_SPAWN = 187;
    public static final int TRACE_SPAWN_INTERNALS = 188;
    public static final int TRACE_SPAWN_ARGV = 189;
    public static final int TRACE_SPAWN_ENV = 190;
    public static final int TRACE_JAVA_HEAP_ALLOCATION = 191;
    public static final int TRACE_JAVA_HEAP_ALLOCATION_INTERNALS = 192;
    public static final int TRACE_CLASS_FILTER_INTERNALS = 193;
    public static final int TRACE_GC_OVERHEAD_LIMITS = 194;
    public static final int TRACE_JDWP_STACK_TRACKER = 195;
    public static final int TRACE_PAR_NEW_GC_INTERNALS = 196;
    public static final int TRACE_PROFILING_MAPPING = 197;
    public static final int TRACE_GC_PROMOTION_FAILURE_INTERNALS = 198;
    public static final int TRACE_VIRTUAL_MEMORY = 199;
    public static final int TRACE_CONTROL_AREA = 200;
    public static final int TRACE_COMPILER = 201;
    public static final int TRACE_LEGACY = 202;
    public static final int TRACE_VM_MISC = 203;
    public static final int TRACE_MCT_INTERNALS = 204;
    public static final int MAX_TRACE_CONSTANT;
    private static final boolean[] isValidFlag;
    private static final String[] flagNames;
    private boolean[] flags = new boolean[MAX_TRACE_CONSTANT + 1];

    public void setFlag(int flag) {
        VmTraceFlagsSet.checkFlag(flag);
        this.flags[flag] = true;
    }

    public void clearFlag(int flag) {
        VmTraceFlagsSet.checkFlag(flag);
        this.flags[flag] = false;
    }

    public boolean isSet(int flag) {
        VmTraceFlagsSet.checkFlag(flag);
        return this.flags[flag];
    }

    public void clearAllFlags() {
        for (int i = 0; i <= MAX_TRACE_CONSTANT; ++i) {
            this.flags[i] = false;
        }
    }

    public void setAllFlags() {
        for (int i = 0; i <= MAX_TRACE_CONSTANT; ++i) {
            this.flags[i] = true;
        }
    }

    public static int getMaxTraceFlag() {
        return MAX_TRACE_CONSTANT;
    }

    public static boolean isValidFlag(int flag) {
        if (flag < 0 || flag > MAX_TRACE_CONSTANT) {
            return false;
        }
        return isValidFlag[flag];
    }

    public static String getFlagName(int flag) {
        if (VmTraceFlagsSet.isValidFlag(flag)) {
            return flagNames[flag];
        }
        return null;
    }

    public static String getFlagDescription(int flag) {
        return VmTraceFlag.getFlagByNumber(flag).getDescription();
    }

    private static void checkFlag(int flag) {
        if (!VmTraceFlagsSet.isValidFlag(flag)) {
            throw new IllegalArgumentException("Flag  is not valid!");
        }
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append("{ ");
        for (int i = 0; i <= MAX_TRACE_CONSTANT; ++i) {
            if (!this.flags[i] || !VmTraceFlagsSet.isValidFlag(i)) continue;
            result.append(VmTraceFlagsSet.getFlagName(i)).append(' ');
        }
        result.append('}');
        return result.toString();
    }

    static {
        int flagNr;
        int i;
        ArrayList<Integer> flags = new ArrayList<Integer>();
        ArrayList<String> names = new ArrayList<String>();
        Field[] fields = VmTraceFlagsSet.class.getDeclaredFields();
        for (int i2 = 0; i2 < fields.length; ++i2) {
            if (fields[i2].getType() != Integer.TYPE || !fields[i2].getName().startsWith("TRACE_")) continue;
            try {
                flags.add(new Integer((int)fields[i2].getLong(null)));
                names.add(fields[i2].getName());
                continue;
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("Cannot access " + fields[i2]);
            }
        }
        int nrOfFlags = flags.size();
        int maxFlagNr = 0;
        for (i = 0; i < nrOfFlags; ++i) {
            flagNr = (Integer)flags.get(i);
            if (flagNr < 0) {
                throw new RuntimeException("Illegal flag " + flagNr);
            }
            maxFlagNr = Math.max(maxFlagNr, flagNr);
        }
        MAX_TRACE_CONSTANT = maxFlagNr;
        isValidFlag = new boolean[maxFlagNr + 1];
        flagNames = new String[maxFlagNr + 1];
        for (i = 0; i < nrOfFlags; ++i) {
            flagNr = (Integer)flags.get(i);
            if (isValidFlag[flagNr]) {
                throw new RuntimeException("Double defined flag " + flagNr);
            }
            VmTraceFlagsSet.isValidFlag[flagNr] = true;
            VmTraceFlagsSet.flagNames[flagNr] = (String)names.get(i);
        }
    }
}

